/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertRows;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainer;
import org.apache.tsfile.annotations.TableModel;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.utils.RamUsageEstimator;

public class InsertRowsStatement
extends InsertBaseStatement {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertRowsStatement.class);
    private List<InsertRowStatement> insertRowStatementList;

    public InsertRowsStatement() {
        this.statementType = StatementType.BATCH_INSERT_ROWS;
    }

    public List<PartialPath> getDevicePaths() {
        ArrayList<PartialPath> partialPaths = new ArrayList<PartialPath>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            partialPaths.add(insertRowStatement.devicePath);
        }
        return partialPaths;
    }

    public List<String[]> getMeasurementsList() {
        ArrayList<String[]> measurementsList = new ArrayList<String[]>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            measurementsList.add(insertRowStatement.measurements);
        }
        return measurementsList;
    }

    public List<TSDataType[]> getDataTypesList() {
        ArrayList<TSDataType[]> dataTypesList = new ArrayList<TSDataType[]>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            dataTypesList.add(insertRowStatement.dataTypes);
        }
        return dataTypesList;
    }

    public List<Boolean> getAlignedList() {
        ArrayList<Boolean> alignedList = new ArrayList<Boolean>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            alignedList.add(insertRowStatement.isAligned);
        }
        return alignedList;
    }

    public List<InsertRowStatement> getInsertRowStatementList() {
        return this.insertRowStatementList;
    }

    public void setInsertRowStatementList(List<InsertRowStatement> insertRowStatementList) {
        this.insertRowStatementList = insertRowStatementList;
    }

    @Override
    public boolean isEmpty() {
        return this.insertRowStatementList.isEmpty();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRows(this, context);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            result.addAll(insertRowStatement.getPaths());
        }
        return result;
    }

    @Override
    public ISchemaValidation getSchemaValidation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ISchemaValidation> getSchemaValidationList() {
        return this.insertRowStatementList.stream().map(InsertRowStatement::getSchemaValidation).collect(Collectors.toList());
    }

    @Override
    public void updateAfterSchemaValidation(MPPQueryContext context) throws QueryProcessException {
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            insertRowStatement.updateAfterSchemaValidation(context);
            if (this.hasFailedMeasurements() || !insertRowStatement.hasFailedMeasurements()) continue;
            this.failedMeasurementIndex2Info = insertRowStatement.failedMeasurementIndex2Info;
        }
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        return false;
    }

    @Override
    public void semanticCheck() {
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            insertRowStatement.semanticCheck();
        }
    }

    @Override
    public long getMinTime() {
        throw new NotImplementedException();
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        throw new NotImplementedException();
    }

    @Override
    public InsertBaseStatement removeLogicalView() {
        ArrayList<InsertRowStatement> mergedList = new ArrayList<InsertRowStatement>();
        boolean needSplit = false;
        for (InsertRowStatement child : this.insertRowStatementList) {
            List<InsertRowStatement> childSplitResult = child.getSplitList();
            needSplit = needSplit || child.isNeedSplit();
            mergedList.addAll(childSplitResult);
        }
        if (!needSplit) {
            return this;
        }
        InsertRowsStatement splitResult = new InsertRowsStatement();
        splitResult.setInsertRowStatementList(mergedList);
        return splitResult;
    }

    public List<Object[]> getDeviceIdListNoTableName() {
        return this.insertRowStatementList.stream().map(s -> {
            Object[] segments = s.getTableDeviceID().getSegments();
            return Arrays.copyOfRange(segments, 1, segments.length);
        }).collect(Collectors.toList());
    }

    @Override
    @TableModel
    public void toLowerCase() {
        this.insertRowStatementList.forEach(InsertBaseStatement::toLowerCase);
    }

    @Override
    protected long calculateBytesUsed() {
        return INSTANCE_SIZE + (Objects.nonNull(this.insertRowStatementList) ? UpdateDetailContainer.LIST_SIZE + this.insertRowStatementList.stream().mapToLong(InsertRowStatement::calculateBytesUsed).reduce(0L, Long::sum) : 0L);
    }

    @Override
    @TableModel
    public Optional<String> getDatabaseName() {
        Optional<String> database = Optional.empty();
        for (InsertRowStatement rowStatement : this.insertRowStatementList) {
            Optional<String> childDatabaseName = rowStatement.getDatabaseName();
            if (childDatabaseName.isPresent() && database.isPresent() && !Objects.equals(childDatabaseName.get(), database.get())) {
                throw new SemanticException("Cannot insert into multiple databases within one statement, please split them manually");
            }
            database = childDatabaseName;
        }
        return database;
    }

    @Override
    @TableModel
    public Statement toRelationalStatement(MPPQueryContext context) {
        return new InsertRows(this, context);
    }

    @Override
    public void removeAttributeColumns() {
        this.subRemoveAttributeColumns(Collections.emptyList());
    }

    @Override
    protected void subRemoveAttributeColumns(List<Integer> columnsToKeep) {
        this.insertRowStatementList.forEach(InsertBaseStatement::removeAttributeColumns);
    }
}

