/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.security;

import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

public class TlsConf {
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final String name;
    private final KeyManagerConf keyManager;
    private final TrustManagerConf trustManager;
    private final boolean mutualTls;

    private TlsConf(String name, KeyManagerConf keyManager, TrustManagerConf trustManager, boolean mutualTls) {
        this.name = JavaUtils.getClassSimpleName(this.getClass()) + COUNT.getAndIncrement() + (name == null ? "" : "-" + name);
        this.keyManager = keyManager;
        this.trustManager = trustManager;
        this.mutualTls = mutualTls;
    }

    protected TlsConf(Builder b) {
        this(b.buildName(), b.buildKeyManagerConf(), b.buildTrustManagerConf(), b.isMutualTls());
    }

    public KeyManagerConf getKeyManager() {
        return this.keyManager;
    }

    public TrustManagerConf getTrustManager() {
        return this.trustManager;
    }

    public boolean isMutualTls() {
        return this.mutualTls;
    }

    public String toString() {
        return this.name;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class KeyManagerConf {
        private final PrivateKeyConf privateKey;
        private final CertificatesConf keyCertificates;
        private final KeyManager keyManager;

        private KeyManagerConf(PrivateKeyConf privateKey, CertificatesConf keyCertificates) {
            this.privateKey = Objects.requireNonNull(privateKey, "privateKey == null");
            this.keyCertificates = Objects.requireNonNull(keyCertificates, "keyCertificates == null");
            Preconditions.assertTrue(privateKey.isFileBased() == keyCertificates.isFileBased(), () -> "The privateKey (isFileBased? " + privateKey.isFileBased() + ") and the keyCertificates (isFileBased? " + keyCertificates.isFileBased() + ") must be either both file based or both not.");
            this.keyManager = null;
        }

        private KeyManagerConf(KeyManager keyManager) {
            this.keyManager = keyManager;
            this.privateKey = null;
            this.keyCertificates = null;
        }

        public PrivateKeyConf getPrivateKey() {
            return this.privateKey;
        }

        public CertificatesConf getKeyCertificates() {
            return this.keyCertificates;
        }

        public boolean isFileBased() {
            return this.privateKey.isFileBased();
        }

        public KeyManager getKeyManager() {
            return this.keyManager;
        }
    }

    public static final class TrustManagerConf {
        private final CertificatesConf trustCertificates;
        private final TrustManager trustManager;

        private TrustManagerConf(CertificatesConf trustCertificates) {
            this.trustCertificates = trustCertificates;
            this.trustManager = null;
        }

        private TrustManagerConf(TrustManager trustManager) {
            this.trustManager = trustManager;
            this.trustCertificates = null;
        }

        public CertificatesConf getTrustCertificates() {
            return this.trustCertificates;
        }

        public TrustManager getTrustManager() {
            return this.trustManager;
        }
    }

    public static class Builder {
        private String name;
        private CertificatesConf trustCertificates;
        private PrivateKeyConf privateKey;
        private CertificatesConf keyCertificates;
        private boolean mutualTls;
        private KeyManager keyManager;
        private TrustManager trustManager;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTrustCertificates(CertificatesConf trustCertificates) {
            this.trustCertificates = trustCertificates;
            return this;
        }

        public Builder setPrivateKey(PrivateKeyConf privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder setKeyCertificates(CertificatesConf keyCertificates) {
            this.keyCertificates = keyCertificates;
            return this;
        }

        public Builder setKeyManager(KeyManager keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        public Builder setTrustManager(TrustManager trustManager) {
            this.trustManager = trustManager;
            return this;
        }

        public Builder setMutualTls(boolean mutualTls) {
            this.mutualTls = mutualTls;
            return this;
        }

        private boolean isMutualTls() {
            return this.mutualTls;
        }

        private String buildName() {
            return Optional.ofNullable(this.name).orElse("");
        }

        private TrustManagerConf buildTrustManagerConf() {
            if (this.trustManager != null) {
                return new TrustManagerConf(this.trustManager);
            }
            return new TrustManagerConf(this.trustCertificates);
        }

        private KeyManagerConf buildKeyManagerConf() {
            if (this.keyManager != null) {
                return new KeyManagerConf(this.keyManager);
            }
            if (this.privateKey == null && this.keyCertificates == null) {
                return null;
            }
            if (this.privateKey != null && this.keyCertificates != null) {
                return new KeyManagerConf(this.privateKey, this.keyCertificates);
            }
            throw new IllegalStateException("The privateKey (null? " + (this.privateKey == null) + ") and the keyCertificates (null? " + (this.keyCertificates == null) + ") must be either both null or both not.");
        }

        public TlsConf build() {
            return new TlsConf(this);
        }
    }

    public static class PrivateKeyConf
    extends FileBasedValue<PrivateKey> {
        public PrivateKeyConf(PrivateKey privateKey) {
            super(privateKey);
        }

        public PrivateKeyConf(File privateKeyFile) {
            super(privateKeyFile);
        }
    }

    public static class CertificatesConf
    extends FileBasedValue<Iterable<X509Certificate>> {
        public CertificatesConf(Iterable<X509Certificate> certificates) {
            super(certificates);
        }

        public CertificatesConf(X509Certificate ... certificates) {
            this((Iterable<X509Certificate>)Arrays.asList(certificates));
        }

        public CertificatesConf(File certificates) {
            super(certificates);
        }
    }

    private static class FileBasedValue<V> {
        private final V value;
        private final File file;

        FileBasedValue(V value) {
            this.value = Objects.requireNonNull(value, () -> "value == null in " + this.getClass());
            this.file = null;
            if (value instanceof Iterable) {
                Iterator i = ((Iterable)value).iterator();
                Preconditions.assertTrue(i.hasNext(), "value is an empty Iterable in " + this.getClass());
                Objects.requireNonNull(i.next(), () -> "The first item in value is null in " + this.getClass());
            }
        }

        FileBasedValue(File file) {
            this.value = null;
            this.file = Objects.requireNonNull(file, () -> "file == null in " + this.getClass());
        }

        public V get() {
            return this.value;
        }

        public File getFile() {
            return this.file;
        }

        public final boolean isFileBased() {
            return this.getFile() != null;
        }
    }
}

