/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CloseSessionRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=471");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=473");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=472");
    private final RequestHeader requestHeader;
    private final Boolean deleteSubscriptions;

    public CloseSessionRequest(RequestHeader requestHeader, Boolean deleteSubscriptions) {
        this.requestHeader = requestHeader;
        this.deleteSubscriptions = deleteSubscriptions;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Boolean getDeleteSubscriptions() {
        return this.deleteSubscriptions;
    }

    protected CloseSessionRequest(CloseSessionRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((CloseSessionRequestBuilder)b).requestHeader;
        this.deleteSubscriptions = ((CloseSessionRequestBuilder)b).deleteSubscriptions;
    }

    public static CloseSessionRequestBuilder<?, ?> builder() {
        return new CloseSessionRequestBuilderImpl();
    }

    public CloseSessionRequestBuilder<?, ?> toBuilder() {
        return new CloseSessionRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloseSessionRequest)) {
            return false;
        }
        CloseSessionRequest other = (CloseSessionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleteSubscriptions = this.getDeleteSubscriptions();
        Boolean other$deleteSubscriptions = other.getDeleteSubscriptions();
        if (this$deleteSubscriptions == null ? other$deleteSubscriptions != null : !((Object)this$deleteSubscriptions).equals(other$deleteSubscriptions)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        return !(this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CloseSessionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleteSubscriptions = this.getDeleteSubscriptions();
        result = result * 59 + ($deleteSubscriptions == null ? 43 : ((Object)$deleteSubscriptions).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CloseSessionRequest(requestHeader=" + this.getRequestHeader() + ", deleteSubscriptions=" + this.getDeleteSubscriptions() + ")";
    }

    private static final class CloseSessionRequestBuilderImpl
    extends CloseSessionRequestBuilder<CloseSessionRequest, CloseSessionRequestBuilderImpl> {
        private CloseSessionRequestBuilderImpl() {
        }

        @Override
        protected CloseSessionRequestBuilderImpl self() {
            return this;
        }

        @Override
        public CloseSessionRequest build() {
            return new CloseSessionRequest(this);
        }
    }

    public static abstract class CloseSessionRequestBuilder<C extends CloseSessionRequest, B extends CloseSessionRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private Boolean deleteSubscriptions;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CloseSessionRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CloseSessionRequest instance, CloseSessionRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.deleteSubscriptions(instance.deleteSubscriptions);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B deleteSubscriptions(Boolean deleteSubscriptions) {
            this.deleteSubscriptions = deleteSubscriptions;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CloseSessionRequest.CloseSessionRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", deleteSubscriptions=" + this.deleteSubscriptions + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CloseSessionRequest> {
        @Override
        public Class<CloseSessionRequest> getType() {
            return CloseSessionRequest.class;
        }

        @Override
        public CloseSessionRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            Boolean deleteSubscriptions = decoder.readBoolean("DeleteSubscriptions");
            return new CloseSessionRequest(requestHeader, deleteSubscriptions);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CloseSessionRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeBoolean("DeleteSubscriptions", value.getDeleteSubscriptions());
        }
    }
}

