/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;

class PageIndexSortBuckets {
    private final short[] bounds;
    private final ArrayDeque[] buckets;
    private final Map<Integer, ISchemaPage> pageContainer;

    public PageIndexSortBuckets(short[] borders, Map<Integer, ISchemaPage> container) {
        this.bounds = Arrays.copyOf(borders, borders.length);
        this.buckets = new ArrayDeque[borders.length];
        this.pageContainer = container;
        for (int i = 0; i < borders.length; ++i) {
            this.buckets[i] = new ArrayDeque();
        }
    }

    public void clear() {
        for (ArrayDeque q : this.buckets) {
            q.clear();
        }
    }

    public void sortIntoBucket(ISchemaPage page, short newSegSize) {
        short availableSize;
        if (page.getAsSegmentedPage() == null) {
            return;
        }
        short s = availableSize = newSegSize < 0 ? (short)(page.getAsSegmentedPage().getSpareSize() - 2) : (short)(page.getAsSegmentedPage().getSpareSize() - newSegSize - 2);
        if (availableSize <= 25) {
            return;
        }
        for (int i = 0; i < this.bounds.length; ++i) {
            if (availableSize > this.bounds[i]) continue;
            this.buckets[i].add(page.getPageIndex());
            return;
        }
    }

    public ArrayDeque<Integer> getBucket(int index) {
        return this.buckets[index];
    }

    public synchronized ISchemaPage getNearestFitPage(short size, boolean withLock) {
        for (int i = 0; i < this.buckets.length && this.pageContainer.size() > 0; ++i) {
            int elemToCheck = this.buckets[i].size();
            while (size < this.bounds[i] && elemToCheck > 0) {
                ISchemaPage targetPage = this.pageContainer.getOrDefault(this.buckets[i].poll(), null);
                --elemToCheck;
                if (targetPage == null || targetPage.getAsSegmentedPage() == null) continue;
                if (withLock && targetPage.getAsSegmentedPage().isCapableForSegSize(size) && targetPage.getLock().writeLock().tryLock()) {
                    if (targetPage.getAsSegmentedPage().isCapableForSegSize(size)) {
                        return targetPage.getAsSegmentedPage();
                    }
                    targetPage.getLock().writeLock().unlock();
                }
                if (!withLock && targetPage.getAsSegmentedPage().isCapableForSegSize(size)) {
                    return targetPage;
                }
                if (i <= 0 || !targetPage.getAsSegmentedPage().isCapableForSegSize(this.bounds[0])) continue;
                this.sortIntoBucket(targetPage, (short)-1);
            }
        }
        return null;
    }
}

