/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileStatus;

public class WALFileUtils {
    public static final Pattern WAL_FILE_NAME_PATTERN = Pattern.compile(String.format("%s(?<%s>\\d+)-(?<%s>\\d+)-(?<%s>\\d+)\\%s$", "_", "versionId", "startSearchIndex", "statusCode", ".wal"));
    public static final String WAL_FILE_NAME_FORMAT = "_%d-%d-%d.wal";

    public static boolean walFilenameFilter(File dir, String name) {
        return WAL_FILE_NAME_PATTERN.matcher(name).find();
    }

    public static File[] listAllWALFiles(File dir) {
        return dir.listFiles(WALFileUtils::walFilenameFilter);
    }

    public static File getWALFile(File dir, long versionId) throws FileNotFoundException {
        String filePrefix = "_" + versionId + "-";
        Object[] files = dir.listFiles((d, name) -> WALFileUtils.walFilenameFilter(d, name) && name.startsWith(filePrefix));
        if (files == null || files.length != 1) {
            throw new FileNotFoundException(String.format("Fail to get wal file by versionId=%s and files=%s.", versionId, Arrays.toString(files)));
        }
        return files[0];
    }

    public static long parseVersionId(String filename) {
        Matcher matcher = WAL_FILE_NAME_PATTERN.matcher(filename);
        if (matcher.find()) {
            return Long.parseLong(matcher.group("versionId"));
        }
        throw new RuntimeException("Invalid wal file name: " + filename);
    }

    public static long parseStartSearchIndex(String filename) {
        Matcher matcher = WAL_FILE_NAME_PATTERN.matcher(filename);
        if (matcher.find()) {
            return Long.parseLong(matcher.group("startSearchIndex"));
        }
        throw new RuntimeException("Invalid wal file name: " + filename);
    }

    public static WALFileStatus parseStatusCode(String filename) {
        Matcher matcher = WAL_FILE_NAME_PATTERN.matcher(filename);
        if (matcher.find()) {
            return WALFileStatus.valueOf(Integer.parseInt(matcher.group("statusCode")));
        }
        throw new RuntimeException("Invalid wal file name: " + filename);
    }

    public static void ascSortByVersionId(File[] walFiles) {
        Arrays.sort(walFiles, Comparator.comparingLong(file -> WALFileUtils.parseVersionId(file.getName())));
    }

    public static int binarySearchFileBySearchIndex(File[] files, long targetSearchIndex) {
        if (files == null || files.length == 0 || targetSearchIndex <= WALFileUtils.parseStartSearchIndex(files[0].getName())) {
            return -1;
        }
        if (targetSearchIndex > WALFileUtils.parseStartSearchIndex(files[files.length - 1].getName())) {
            return files.length - 1;
        }
        int low = 0;
        int high = files.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = WALFileUtils.parseStartSearchIndex(files[mid].getName());
            if (midVal < targetSearchIndex) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low - 1;
    }

    public static String getLogFileName(long versionId, long startSearchIndex, WALFileStatus status) {
        return String.format(WAL_FILE_NAME_FORMAT, versionId, startSearchIndex, status.getCode());
    }

    public static String getTsFileRelativePath(String absolutePath) {
        Path path = new File(absolutePath).toPath();
        return path.subpath(path.getNameCount() - 5, path.getNameCount()).toString();
    }
}

