/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateFunction;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateFunctionStatement;
import org.apache.iotdb.udf.api.UDF;
import org.apache.iotdb.udf.api.relational.SQLFunction;

public class CreateFunctionTask
implements IConfigTask {
    private final Model model;
    private final String udfName;
    private final String className;
    private final Optional<String> uriString;
    private final Class<?> baseClazz;

    public CreateFunctionTask(CreateFunctionStatement createFunctionStatement) {
        this.udfName = createFunctionStatement.getUdfName();
        this.className = createFunctionStatement.getClassName();
        this.uriString = createFunctionStatement.getUriString();
        this.baseClazz = UDF.class;
        this.model = Model.TREE;
    }

    public CreateFunctionTask(CreateFunction createFunctionStatement) {
        this.udfName = createFunctionStatement.getUdfName();
        this.className = createFunctionStatement.getClassName();
        this.uriString = createFunctionStatement.getUriString();
        this.baseClazz = SQLFunction.class;
        this.model = Model.TABLE;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.createFunction(this.model, this.udfName, this.className, this.uriString, this.baseClazz);
    }
}

