/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.GroupReference;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;

public final class Plans {
    public static PlanNode resolveGroupReferences(PlanNode node, Lookup lookup) {
        Objects.requireNonNull(node, "node is null");
        return node.accept(new ResolvingVisitor(lookup), null);
    }

    private Plans() {
    }

    private static class ResolvingVisitor
    extends PlanVisitor<PlanNode, Void> {
        private final Lookup lookup;

        public ResolvingVisitor(Lookup lookup) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        public PlanNode visitPlan(PlanNode node, Void context) {
            List<PlanNode> children = node.getChildren().stream().map(child -> child.accept(this, context)).collect(Collectors.toList());
            return node.replaceChildren(children);
        }

        @Override
        public PlanNode visitGroupReference(GroupReference node, Void context) {
            return this.lookup.resolve(node).accept(this, context);
        }
    }
}

