/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.MailetUtil;

public class RelayLimit
extends GenericMatcher {
    int limit = 30;

    public void init() throws MessagingException {
        this.limit = MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)this.getCondition());
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        MimeMessage mm = mail.getMessage();
        int count = 0;
        Enumeration e = mm.getAllHeaders();
        while (e.hasMoreElements()) {
            Header hdr = (Header)e.nextElement();
            if (!hdr.getName().equals("Received")) continue;
            ++count;
        }
        if (count >= this.limit) {
            return mail.getRecipients();
        }
        return null;
    }
}

