/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.net.UrlEscapers;
import java.util.Optional;
import org.apache.james.core.healthcheck.Result;

@JsonPropertyOrder(value={"componentName", "escapedComponentName", "status", "cause"})
public class HealthCheckExecutionResultDto {
    private final Result healthCheckResult;

    public HealthCheckExecutionResultDto(Result healthCheckResult) {
        this.healthCheckResult = healthCheckResult;
    }

    public String getComponentName() {
        return this.healthCheckResult.getComponentName().getName();
    }

    public String getEscapedComponentName() {
        return UrlEscapers.urlPathSegmentEscaper().escape(this.healthCheckResult.getComponentName().getName());
    }

    public String getStatus() {
        return this.healthCheckResult.getStatus().getValue();
    }

    public Optional<String> getCause() {
        return this.healthCheckResult.getCause();
    }
}

