/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeModule;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.server.task.json.JsonTaskAdditionalInformationSerializer;
import org.apache.james.task.Hostname;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskType;
import org.apache.james.task.eventsourcing.cassandra.CassandraTaskExecutionDetailsProjectionTable$;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\f\u0019\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A1\t\u0001B\u0001B\u0003%A\tC\u0003N\u0001\u0011\u0005a\nC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\u0015\u0004\u0001\u0015!\u0003`\u0011\u001d1\u0007A1A\u0005\n\u001dDaa\u001b\u0001!\u0002\u0013A\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007c\u0002\u0001\u000b\u0011\u00028\t\u000fI\u0004!\u0019!C\u0005[\"11\u000f\u0001Q\u0001\n9Dq\u0001\u001e\u0001C\u0002\u0013%Q\u000e\u0003\u0004v\u0001\u0001\u0006IA\u001c\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0002+\u0007\u0006\u001c8/\u00198ee\u0006$\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0012+G/Y5mgB\u0013xN[3di&|g\u000eR!P\u0015\tI\"$A\u0005dCN\u001c\u0018M\u001c3sC*\u00111\u0004H\u0001\u000eKZ,g\u000e^:pkJ\u001c\u0017N\\4\u000b\u0005uq\u0012\u0001\u0002;bg.T!a\b\u0011\u0002\u000b)\fW.Z:\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\bg\u0016\u001c8/[8o!\tqs'D\u00010\u0015\t\u0001\u0014'\u0001\u0003d_J,'B\u0001\u001a4\u0003\u0019!'/\u001b<fe*\u0011A'N\u0001\tI\u0006$\u0018m\u001d;bq*\ta'A\u0002d_6L!\u0001O\u0018\u0003\u000fM+7o]5p]\u0006iA/\u001f9fgB\u0013xN^5eKJ\u0004\"aO!\u000e\u0003qR!!\u0010 \u0002\t%t\u0017\u000e\u001e\u0006\u00033}R!\u0001\u0011\u0010\u0002\u0011\t\f7m[3oINL!A\u0011\u001f\u0003-\r\u000b7o]1oIJ\fG+\u001f9fgB\u0013xN^5eKJ\fqE[:p]R\u000b7o[!eI&$\u0018n\u001c8bY&sgm\u001c:nCRLwN\\*fe&\fG.\u001b>feB\u0011QiS\u0007\u0002\r*\u0011q\tS\u0001\u0005UN|gN\u0003\u0002\u001e\u0013*\u0011!JH\u0001\u0007g\u0016\u0014h/\u001a:\n\u000513%a\n&t_:$\u0016m]6BI\u0012LG/[8oC2LeNZ8s[\u0006$\u0018n\u001c8TKJL\u0017\r\\5{KJ\fa\u0001P5oSRtD\u0003B(R%N\u0003\"\u0001\u0015\u0001\u000e\u0003aAQ\u0001\f\u0003A\u00025BQ!\u000f\u0003A\u0002iBQa\u0011\u0003A\u0002\u0011C#\u0001B+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016AB5oU\u0016\u001cGOC\u0001[\u0003\u0015Q\u0017M^1y\u0013\tavK\u0001\u0004J]*,7\r^\u0001\u0017G\u0006\u001c8/\u00198ee\u0006\f5/\u001f8d\u000bb,7-\u001e;peV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002c}\u0005)Q\u000f^5mg&\u0011A-\u0019\u0002\u0017\u0007\u0006\u001c8/\u00198ee\u0006\f5/\u001f8d\u000bb,7-\u001e;pe\u000692-Y:tC:$'/Y!ts:\u001cW\t_3dkR|'\u000fI\u0001\tI\u0006$X\rV=qKV\t\u0001\u000e\u0005\u0002/S&\u0011!n\f\u0002\t+N,'\u000fV=qK\u0006IA-\u0019;f)f\u0004X\rI\u0001\u0010S:\u001cXM\u001d;Ti\u0006$X-\\3oiV\ta\u000e\u0005\u0002/_&\u0011\u0001o\f\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\u0018\u0001E5og\u0016\u0014Ho\u0015;bi\u0016lWM\u001c;!\u0003=\u0019X\r\\3diN#\u0018\r^3nK:$\u0018\u0001E:fY\u0016\u001cGo\u0015;bi\u0016lWM\u001c;!\u00035a\u0017n\u001d;Ti\u0006$X-\\3oi\u0006qA.[:u'R\fG/Z7f]R\u0004\u0013aC:bm\u0016$U\r^1jYN$2\u0001_A\n!\u0011Ix0a\u0001\u000e\u0003iT!a\u001f?\u0002\u0013A,(\r\\5tQ\u0016\u0014(B\u0001\u0019~\u0015\u0005q\u0018a\u0002:fC\u000e$xN]\u0005\u0004\u0003\u0003Q(\u0001B'p]>\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003mC:<'BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u0011q\u0001\u0002\u0005->LG\rC\u0004\u0002\u0016=\u0001\r!a\u0006\u0002\u000f\u0011,G/Y5mgB!\u0011\u0011DA\u000e\u001b\u0005a\u0012bAA\u000f9\t!B+Y:l\u000bb,7-\u001e;j_:$U\r^1jYN\fqCY5oI>\u0003H/[8oC2\u001cFO]5oOZ\u000bG.^3\u0015\u0011\u0005\r\u0012\u0011FA\u0017\u0003\u000f\u00022ALA\u0013\u0013\r\t9c\f\u0002\u000f\u0005>,h\u000eZ*uCR,W.\u001a8u\u0011\u001d\tY\u0003\u0005a\u0001\u0003G\t\u0011b\u001d;bi\u0016lWM\u001c;\t\u000f\u0005=\u0002\u00031\u0001\u00022\u0005Ia-[3mI:\u000bW.\u001a\t\u0005\u0003g\t\tE\u0004\u0003\u00026\u0005u\u0002cAA\u001cQ5\u0011\u0011\u0011\b\u0006\u0004\u0003w!\u0013A\u0002\u001fs_>$h(C\u0002\u0002@!\na\u0001\u0015:fI\u00164\u0017\u0002BA\"\u0003\u000b\u0012aa\u0015;sS:<'bAA Q!9\u0011\u0011\n\tA\u0002\u0005-\u0013A\u00034jK2$g+\u00197vKB1\u0011QJA*\u0003ci!!a\u0014\u000b\t\u0005E\u00131B\u0001\u0005kRLG.\u0003\u0003\u0002V\u0005=#\u0001C(qi&|g.\u00197\u0002)\tLg\u000eZ(qi&|g.\u00197V\tR3\u0016\r\\;f)!\t\u0019#a\u0017\u0002^\u0005}\u0003bBA\u0016#\u0001\u0007\u00111\u0005\u0005\b\u0003_\t\u0002\u0019AA\u0019\u0011\u001d\tI%\u0005a\u0001\u0003C\u0002b!!\u0014\u0002T\u0005\r\u0004c\u0001\u0018\u0002f%\u0019\u0011qM\u0018\u0003\u0011U#EKV1mk\u0016\fad]3sS\u0006d\u0017N_3BI\u0012LG/[8oC2LeNZ8s[\u0006$\u0018n\u001c8\u0015\t\u0005-\u0013Q\u000e\u0005\b\u0003+\u0011\u0002\u0019AA\f\u0003-\u0011X-\u00193EKR\f\u0017\u000e\\:\u0015\t\u0005M\u0014Q\u000f\t\u0005s~\f9\u0002C\u0004\u0002xM\u0001\r!!\u001f\u0002\rQ\f7o[%e!\u0011\tI\"a\u001f\n\u0007\u0005uDD\u0001\u0004UCN\\\u0017\nZ\u0001\fY&\u001cH\u000fR3uC&d7\u000f\u0006\u0002\u0002\u0004B)\u00110!\"\u0002\u0018%\u0019\u0011q\u0011>\u0003\t\u0019cW\u000f_\u0001\be\u0016\fGMU8x)\u0011\t9\"!$\t\u000f\u0005=U\u00031\u0001\u0002\u0012\u0006\u0019!o\\<\u0011\u00079\n\u0019*C\u0002\u0002\u0016>\u00121AU8x\u0003\u0001\"Wm]3sS\u0006d\u0017N_3BI\u0012LG/[8oC2LeNZ8s[\u0006$\u0018n\u001c8\u0015\r\u0005m\u00151VA[!\u0019\ti%a\u0015\u0002\u001eB!\u0011qTAS\u001d\u0011\tI\"!)\n\u0007\u0005\rF$\u0001\u000bUCN\\W\t_3dkRLwN\u001c#fi\u0006LGn]\u0005\u0005\u0003O\u000bIKA\u000bBI\u0012LG/[8oC2LeNZ8s[\u0006$\u0018n\u001c8\u000b\u0007\u0005\rF\u0004C\u0004\u0002.Z\u0001\r!a,\u0002\u0011Q\f7o\u001b+za\u0016\u0004B!!\u0007\u00022&\u0019\u00111\u0017\u000f\u0003\u0011Q\u000b7o\u001b+za\u0016Dq!a$\u0017\u0001\u0004\t\t\n")
public class CassandraTaskExecutionDetailsProjectionDAO {
    private final JsonTaskAdditionalInformationSerializer jsonTaskAdditionalInformationSerializer;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final UserType dateType;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement listStatement;

    private CassandraAsyncExecutor cassandraAsyncExecutor() {
        return this.cassandraAsyncExecutor;
    }

    private UserType dateType() {
        return this.dateType;
    }

    private PreparedStatement insertStatement() {
        return this.insertStatement;
    }

    private PreparedStatement selectStatement() {
        return this.selectStatement;
    }

    private PreparedStatement listStatement() {
        return this.listStatement;
    }

    public Mono<Void> saveDetails(TaskExecutionDetails details) {
        BoundStatement boundStatement = this.insertStatement().bind().setUUID(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), details.getTaskId().getValue()).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE(), details.getType().asString()).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS(), details.getStatus().getValue()).setUDTValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE(), CassandraZonedDateTimeModule.toUDT((UserType)this.dateType(), (ZonedDateTime)details.getSubmittedDate())).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE(), details.getSubmittedNode().asString());
        .colon.colon bindOptionalFieldOperations = new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE(), CassandraZonedDateTimeModule.toUDT((UserType)this.dateType(), (Optional)details.getStartedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE(), details.getRanNode().map(x$1 -> x$1.asString())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE(), CassandraZonedDateTimeModule.toUDT((UserType)this.dateType(), (Optional)details.getCompletedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE(), CassandraZonedDateTimeModule.toUDT((UserType)this.dateType(), (Optional)details.getCanceledDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE(), details.getCancelRequestedNode().map(x$2 -> x$2.asString())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE(), CassandraZonedDateTimeModule.toUDT((UserType)this.dateType(), (Optional)details.getFailedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION(), this.serializeAdditionalInformation(details)), (List)Nil$.MODULE$)))))));
        BoundStatement fullyBoundStatement = (BoundStatement)bindOptionalFieldOperations.foldLeft((Object)boundStatement, (Function2 & Serializable)(statement, bindFieldOperation) -> (BoundStatement)bindFieldOperation.apply(statement));
        return this.cassandraAsyncExecutor().executeVoid((Statement)fullyBoundStatement);
    }

    private BoundStatement bindOptionalStringValue(BoundStatement statement, String fieldName, Optional<String> fieldValue) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(fieldValue));
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return statement.setString(fieldName, value);
        }
        if (None$.MODULE$.equals(option)) {
            return statement;
        }
        throw new MatchError((Object)option);
    }

    private BoundStatement bindOptionalUDTValue(BoundStatement statement, String fieldName, Optional<UDTValue> fieldValue) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(fieldValue));
        if (option instanceof Some) {
            Some some = (Some)option;
            UDTValue value = (UDTValue)some.value();
            return statement.setUDTValue(fieldName, value);
        }
        if (None$.MODULE$.equals(option)) {
            return statement;
        }
        throw new MatchError((Object)option);
    }

    private Optional<String> serializeAdditionalInformation(TaskExecutionDetails details) {
        return details.getAdditionalInformation().map(x$1 -> $this.jsonTaskAdditionalInformationSerializer.serialize(x$1));
    }

    public Mono<TaskExecutionDetails> readDetails(TaskId taskId) {
        return this.cassandraAsyncExecutor().executeSingleRow((Statement)this.selectStatement().bind().setUUID(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), taskId.getValue())).map(row -> this.readRow((Row)row));
    }

    public Flux<TaskExecutionDetails> listDetails() {
        return this.cassandraAsyncExecutor().executeRows((Statement)this.listStatement().bind()).map(row -> this.readRow((Row)row));
    }

    private TaskExecutionDetails readRow(Row row) {
        TaskType taskType = TaskType.of((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE()));
        TaskId x$1 = TaskId.fromUUID((UUID)row.getUUID(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()));
        TaskType x$2 = TaskType.of((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE()));
        TaskManager.Status x$32 = TaskManager.Status.fromString((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS()));
        ZonedDateTime x$42 = CassandraZonedDateTimeModule.fromUDT((UDTValue)row.getUDTValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE()));
        Hostname x$5 = new Hostname(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE()));
        Optional x$6 = CassandraZonedDateTimeModule.fromUDTOptional((UDTValue)row.getUDTValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE()));
        Optional<Hostname> x$7 = Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE())).map(x$3 -> new Hostname(x$3));
        Optional x$8 = CassandraZonedDateTimeModule.fromUDTOptional((UDTValue)row.getUDTValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE()));
        Optional x$9 = CassandraZonedDateTimeModule.fromUDTOptional((UDTValue)row.getUDTValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE()));
        Optional<Hostname> x$10 = Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE())).map(x$4 -> new Hostname(x$4));
        Optional x$11 = CassandraZonedDateTimeModule.fromUDTOptional((UDTValue)row.getUDTValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE()));
        Function0 & Serializable x$12 = (Function0 & Serializable)() -> this.deserializeAdditionalInformation(taskType, row);
        return new TaskExecutionDetails(x$1, x$2, x$32, x$42, x$5, (Function0)x$12, x$6, x$7, x$8, x$9, x$10, x$11);
    }

    private Optional<TaskExecutionDetails.AdditionalInformation> deserializeAdditionalInformation(TaskType taskType, Row row) {
        return Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION())).map(additionalInformation -> $this.jsonTaskAdditionalInformationSerializer.deserialize(additionalInformation));
    }

    @Inject
    public CassandraTaskExecutionDetailsProjectionDAO(Session session, CassandraTypesProvider typesProvider, JsonTaskAdditionalInformationSerializer jsonTaskAdditionalInformationSerializer) {
        this.jsonTaskAdditionalInformationSerializer = jsonTaskAdditionalInformationSerializer;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.dateType = typesProvider.getDefinedUserType("zonedDateTime");
        this.insertStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION())));
        this.selectStatement = session.prepare((RegularStatement)QueryBuilder.select().from(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).where(QueryBuilder.eq((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), (Object)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()))));
        this.listStatement = session.prepare((RegularStatement)QueryBuilder.select().from(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()));
    }
}

