/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public abstract class AbstractConnectionPool
implements ConnectionPool,
Dumpable {
    private static final Logger LOG = Log.getLogger(AbstractConnectionPool.class);
    private final AtomicBiInteger connections = new AtomicBiInteger();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HttpDestination destination;
    private final int maxConnections;
    private final Callback requester;

    @Deprecated
    protected AbstractConnectionPool(Destination destination, int maxConnections, Callback requester) {
        this((HttpDestination)destination, maxConnections, requester);
    }

    protected AbstractConnectionPool(HttpDestination destination, int maxConnections, Callback requester) {
        this.destination = destination;
        this.maxConnections = maxConnections;
        this.requester = requester;
    }

    protected HttpDestination getHttpDestination() {
        return this.destination;
    }

    @ManagedAttribute(value="The max number of connections", readonly=true)
    public int getMaxConnectionCount() {
        return this.maxConnections;
    }

    @ManagedAttribute(value="The number of connections", readonly=true)
    public int getConnectionCount() {
        return this.connections.getLo();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    @Deprecated
    public int getPendingCount() {
        return this.getPendingConnectionCount();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    public int getPendingConnectionCount() {
        return this.connections.getHi();
    }

    @Override
    public boolean isEmpty() {
        return this.connections.getLo() == 0;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public Connection acquire() {
        return this.acquire(true);
    }

    protected Connection acquire(boolean create) {
        Connection connection = this.activate();
        if (connection == null && create) {
            this.tryCreate(this.destination.getQueuedRequestCount());
            connection = this.activate();
        }
        return connection;
    }

    protected void tryCreate(int maxPending) {
        int total;
        int pending;
        long encoded;
        do {
            encoded = this.connections.get();
            pending = AtomicBiInteger.getHi((long)encoded);
            total = AtomicBiInteger.getLo((long)encoded);
            if (LOG.isDebugEnabled()) {
                LOG.debug("tryCreate {}/{} connections {}/{} pending", new Object[]{total, this.maxConnections, pending, maxPending});
            }
            if (total >= this.maxConnections) {
                return;
            }
            if (maxPending < 0 || pending < maxPending) continue;
            return;
        } while (!this.connections.compareAndSet(encoded, pending + 1, total + 1));
        if (LOG.isDebugEnabled()) {
            LOG.debug("newConnection {}/{} connections {}/{} pending", new Object[]{total + 1, this.maxConnections, pending + 1, maxPending});
        }
        this.destination.newConnection(new Promise<Connection>(){

            public void succeeded(Connection connection) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection {}/{} creation succeeded {}", new Object[]{total + 1, AbstractConnectionPool.this.maxConnections, connection});
                }
                AbstractConnectionPool.this.connections.add(-1, 0);
                AbstractConnectionPool.this.onCreated(connection);
                AbstractConnectionPool.this.proceed();
            }

            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection " + (total + 1) + "/" + AbstractConnectionPool.this.maxConnections + " creation failed", x);
                }
                AbstractConnectionPool.this.connections.add(-1, -1);
                AbstractConnectionPool.this.requester.failed(x);
            }
        });
    }

    protected abstract void onCreated(Connection var1);

    protected void proceed() {
        this.requester.succeeded();
    }

    protected abstract Connection activate();

    protected Connection active(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection active {}", new Object[]{connection});
        }
        this.acquired(connection);
        return connection;
    }

    protected void acquired(Connection connection) {
    }

    protected boolean idle(Connection connection, boolean close) {
        if (close) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection idle close {}", new Object[]{connection});
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection idle {}", new Object[]{connection});
        }
        return true;
    }

    protected void released(Connection connection) {
    }

    protected void removed(Connection connection) {
        int pooled = this.connections.addAndGetLo(-1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection removed {} - pooled: {}", new Object[]{connection, pooled});
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.connections.set(0, 0);
        }
    }

    protected void close(Collection<Connection> connections) {
        connections.forEach(Connection::close);
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }
}

