/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.main;

import java.util.Optional;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultImapDecoder
implements ImapDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultImapDecoder.class);
    private final StatusResponseFactory responseFactory;
    private final ImapCommandParserFactory imapCommands;
    private final int maxInvalidCommands;
    private static final String INVALID_COMMAND_COUNT = "INVALID_COMMAND_COUNT";
    private static final int DEFAULT_MAX_INVALID_COMMANDS = 9;

    public DefaultImapDecoder(StatusResponseFactory responseFactory, ImapCommandParserFactory imapCommands) {
        this(responseFactory, imapCommands, 9);
    }

    public DefaultImapDecoder(StatusResponseFactory responseFactory, ImapCommandParserFactory imapCommands, int maxInvalidCommands) {
        this.responseFactory = responseFactory;
        this.imapCommands = imapCommands;
        this.maxInvalidCommands = maxInvalidCommands;
    }

    @Override
    public ImapMessage decode(ImapRequestLineReader request, ImapSession session) {
        try {
            Tag tag = request.tag();
            return this.decodeCommandTagged(request, tag, session);
        }
        catch (DecodingException e) {
            LOGGER.debug("Cannot parse tag", (Throwable)e);
            return this.unknownCommand(null, session);
        }
    }

    private ImapMessage decodeCommandTagged(ImapRequestLineReader request, Tag tag, ImapSession session) {
        LOGGER.debug("Got <tag>: {}", (Object)tag);
        try {
            String commandName = request.atom();
            return this.decodeCommandNamed(request, tag, commandName, session);
        }
        catch (DecodingException e) {
            LOGGER.debug("Error during initial request parsing", (Throwable)e);
            return this.unknownCommand(tag, session);
        }
    }

    private ImapMessage unknownCommand(Tag tag, ImapSession session) {
        int count = this.retrieveUnknownCommandCount(session) + 1;
        if (count > this.maxInvalidCommands || session.getState() == ImapSessionState.NON_AUTHENTICATED) {
            StatusResponse message = this.responseFactory.bye(HumanReadableText.BYE_UNKNOWN_COMMAND);
            session.logout();
            return message;
        }
        session.setAttribute(INVALID_COMMAND_COUNT, count);
        if (tag == null) {
            return this.responseFactory.untaggedBad(HumanReadableText.UNKNOWN_COMMAND);
        }
        return this.responseFactory.taggedBad(tag, null, HumanReadableText.UNKNOWN_COMMAND);
    }

    private int retrieveUnknownCommandCount(ImapSession session) {
        return Optional.ofNullable(session.getAttribute(INVALID_COMMAND_COUNT)).map(Integer.class::cast).orElse(0);
    }

    private ImapMessage decodeCommandNamed(ImapRequestLineReader request, Tag tag, String commandName, ImapSession session) {
        LOGGER.debug("Got <command>: {}", (Object)commandName);
        ImapCommandParser command = this.imapCommands.getParser(commandName);
        if (command == null) {
            LOGGER.info("Missing command implementation for commmand {}", (Object)commandName);
            return this.unknownCommand(tag, session);
        }
        ImapMessage message = command.parse(request, tag, session);
        session.setAttribute(INVALID_COMMAND_COUNT, 0);
        return message;
    }
}

