/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.migration;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class MessageDenormalizationMigration
implements Migration {
    public static final Logger LOGGER = LoggerFactory.getLogger(MessageDenormalizationMigration.class);
    public static final TaskType TYPE = TaskType.of((String)"message-denormalization-migration");
    private final CassandraMessageDAOV3 messageDAOV3;
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final CassandraMessageIdDAO messageIdDAO;

    @Inject
    public MessageDenormalizationMigration(CassandraMessageDAOV3 messageDAOV3, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO) {
        this.messageDAOV3 = messageDAOV3;
        this.imapUidDAO = imapUidDAO;
        this.messageIdDAO = messageIdDAO;
    }

    public void apply() {
        this.messageIdDAO.retrieveAllMessages().filter(metadata -> !metadata.isComplete()).flatMap(this::retrieveFullMetadata, 16).flatMap(this.messageIdDAO::insert, 4).subscribeOn(Schedulers.elastic()).then().block();
        this.imapUidDAO.retrieveAllMessages().filter(metadata -> !metadata.isComplete()).flatMap(this::retrieveFullMetadata, 16).concatMap(this.imapUidDAO::insertForce, 4).subscribeOn(Schedulers.elastic()).then().block();
    }

    private Mono<CassandraMessageMetadata> retrieveFullMetadata(CassandraMessageMetadata metadata) {
        return this.messageDAOV3.retrieveMessage(metadata.getComposedMessageId(), MessageMapper.FetchType.METADATA).map(messageRepresentation -> CassandraMessageMetadata.builder().ids(metadata.getComposedMessageId()).bodyStartOctet(messageRepresentation.getBodyStartOctet()).size(messageRepresentation.getSize()).internalDate(messageRepresentation.getInternalDate()).headerContent(Optional.of(messageRepresentation.getHeaderId())).build());
    }

    public Task asTask() {
        return new MessageDenormalizationMigrationTask(this);
    }

    static class MessageDenormalizationMigrationTask
    implements Task {
        private final MessageDenormalizationMigration migration;

        MessageDenormalizationMigrationTask(MessageDenormalizationMigration migration) {
            this.migration = migration;
        }

        public Task.Result run() throws InterruptedException {
            return this.migration.runTask();
        }

        public TaskType type() {
            return TYPE;
        }

        public Optional<TaskExecutionDetails.AdditionalInformation> details() {
            return Optional.empty();
        }
    }
}

