/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.JmapRuleDTO;

public class GetFilterResponse
implements Method.Response {
    private final String accountId;
    private final String state;
    private final List<JmapRuleDTO> rules;

    public static Builder builder() {
        return new Builder();
    }

    private GetFilterResponse(String accountId, String state, List<JmapRuleDTO> rules) {
        this.accountId = accountId;
        this.state = state;
        this.rules = rules;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getState() {
        return this.state;
    }

    public List<JmapRuleDTO> getSingleton() {
        return this.rules;
    }

    public static class Builder {
        private String accountId;
        private String state;
        private ImmutableList.Builder<JmapRuleDTO> rules = ImmutableList.builder();

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder rules(List<Rule> rules) {
            this.rules.addAll((Iterable)rules.stream().map(JmapRuleDTO::from).collect(ImmutableList.toImmutableList()));
            return this;
        }

        public GetFilterResponse build() {
            return new GetFilterResponse(this.accountId, this.state, (List<JmapRuleDTO>)this.rules.build());
        }
    }
}

