/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaUsageValue;

public class QuotaSizeUsage
implements QuotaUsageValue<QuotaSizeUsage, QuotaSizeLimit> {
    private final Long value;

    public static QuotaSizeUsage size(long value) {
        return new QuotaSizeUsage(value);
    }

    private QuotaSizeUsage(Long value) {
        this.value = value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public QuotaSizeUsage add(long additionalValue) {
        return new QuotaSizeUsage(this.value + additionalValue);
    }

    @Override
    public QuotaSizeUsage add(QuotaSizeUsage additionalValue) {
        return new QuotaSizeUsage(this.value + additionalValue.asLong());
    }

    @Override
    public boolean exceedLimit(QuotaSizeLimit limit) {
        if (limit.isLimited()) {
            return this.value > limit.asLong();
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value.toString()).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaSizeUsage) {
            QuotaSizeUsage that = (QuotaSizeUsage)o;
            return Objects.equal((Object)this.value, (Object)that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }
}

