/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum RouteToBackendSetRoutingType {
    ABSOLUTE_ROUTING(-96),
    ROUTING_HINT(-95);

    private final byte berType;

    private RouteToBackendSetRoutingType(byte berType) {
        this.berType = berType;
    }

    public byte getBERType() {
        return this.berType;
    }

    @Nullable
    public static RouteToBackendSetRoutingType valueOf(byte berType) {
        for (RouteToBackendSetRoutingType t : RouteToBackendSetRoutingType.values()) {
            if (t.berType != berType) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static RouteToBackendSetRoutingType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "absoluterouting": 
            case "absolute-routing": 
            case "absolute_routing": {
                return ABSOLUTE_ROUTING;
            }
            case "routinghint": 
            case "routing-hint": 
            case "routing_hint": {
                return ROUTING_HINT;
            }
        }
        return null;
    }
}

