/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.unboundidds.monitors.HealthCheckState;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LoadBalancingAlgorithmServerAvailabilityData
implements Serializable {
    private static final long serialVersionUID = -2195372034654700615L;
    @NotNull
    private final HealthCheckState healthCheckState;
    private final int serverPort;
    @NotNull
    private final String serverAddress;

    LoadBalancingAlgorithmServerAvailabilityData(@NotNull String s) {
        int firstColonPos = s.indexOf(58);
        int secondColonPos = s.indexOf(58, firstColonPos + 1);
        this.serverAddress = s.substring(0, firstColonPos);
        this.serverPort = Integer.parseInt(s.substring(firstColonPos + 1, secondColonPos));
        this.healthCheckState = HealthCheckState.forName(s.substring(secondColonPos + 1));
    }

    @NotNull
    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    @NotNull
    public HealthCheckState getHealthCheckState() {
        return this.healthCheckState;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("LoadBalancingAlgorithmServerAvailabilityData(address=");
        buffer.append(this.serverAddress);
        buffer.append(", port=");
        buffer.append(this.serverPort);
        buffer.append(", healthCheckState=");
        buffer.append(this.healthCheckState.name());
        buffer.append(')');
    }

    @NotNull
    public String toCompactString() {
        return this.serverAddress + ':' + this.serverPort + ':' + this.healthCheckState.name();
    }
}

