/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AuditDataSecurityTask
extends Task {
    @NotNull
    static final String AUDIT_DATA_SECURITY_TASK_CLASS = "com.unboundid.directory.server.tasks.AuditDataSecurityTask";
    @NotNull
    private static final String ATTR_INCLUDE_AUDITOR = "ds-task-audit-data-security-include-auditor";
    @NotNull
    private static final String ATTR_EXCLUDE_AUDITOR = "ds-task-audit-data-security-exclude-auditor";
    @NotNull
    private static final String ATTR_BACKEND_ID = "ds-task-audit-data-security-backend-id";
    @NotNull
    private static final String ATTR_REPORT_FILTER = "ds-task-audit-data-security-report-filter";
    @NotNull
    private static final String ATTR_OUTPUT_DIRECTORY = "ds-task-audit-data-security-output-directory";
    @NotNull
    private static final String OC_AUDIT_DATA_SECURITY_TASK = "ds-task-audit-data-security";
    @NotNull
    private static final TaskProperty PROPERTY_INCLUDE_AUDITOR = new TaskProperty("ds-task-audit-data-security-include-auditor", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_INCLUDE_AUDITOR.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_INCLUDE_AUDITOR.get(), String.class, false, true, false);
    @NotNull
    private static final TaskProperty PROPERTY_EXCLUDE_AUDITOR = new TaskProperty("ds-task-audit-data-security-exclude-auditor", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_EXCLUDE_AUDITOR.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_EXCLUDE_AUDITOR.get(), String.class, false, true, false);
    @NotNull
    private static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-audit-data-security-backend-id", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_BACKEND_ID.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_BACKEND_ID.get(), String.class, false, true, false);
    @NotNull
    private static final TaskProperty PROPERTY_REPORT_FILTER = new TaskProperty("ds-task-audit-data-security-report-filter", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_REPORT_FILTER.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_REPORT_FILTER.get(), String.class, false, true, false);
    @NotNull
    private static final TaskProperty PROPERTY_OUTPUT_DIRECTORY = new TaskProperty("ds-task-audit-data-security-output-directory", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_OUTPUT_DIR.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_OUTPUT_DIR.get(), String.class, false, false, false);
    private static final long serialVersionUID = -4994621474763299632L;
    @NotNull
    private final List<String> backendIDs;
    @NotNull
    private final List<String> excludeAuditors;
    @NotNull
    private final List<String> includeAuditors;
    @NotNull
    private final List<String> reportFilters;
    @Nullable
    private final String outputDirectory;

    public AuditDataSecurityTask() {
        this.excludeAuditors = null;
        this.includeAuditors = null;
        this.backendIDs = null;
        this.reportFilters = null;
        this.outputDirectory = null;
    }

    public AuditDataSecurityTask(@Nullable List<String> includeAuditors, @Nullable List<String> excludeAuditors, @Nullable List<String> backendIDs, @Nullable List<String> reportFilters, @Nullable String outputDirectory) {
        this(null, includeAuditors, excludeAuditors, backendIDs, reportFilters, outputDirectory, null, null, null, null, null);
    }

    public AuditDataSecurityTask(@Nullable String taskID, @Nullable List<String> includeAuditors, @Nullable List<String> excludeAuditors, @Nullable List<String> backendIDs, @Nullable List<String> reportFilters, @Nullable String outputDirectory, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, includeAuditors, excludeAuditors, backendIDs, reportFilters, outputDirectory, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public AuditDataSecurityTask(@Nullable String taskID, @Nullable List<String> includeAuditors, @Nullable List<String> excludeAuditors, @Nullable List<String> backendIDs, @Nullable List<String> reportFilters, @Nullable String outputDirectory, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, AUDIT_DATA_SECURITY_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.includeAuditors = AuditDataSecurityTask.getStringList(includeAuditors);
        this.excludeAuditors = AuditDataSecurityTask.getStringList(excludeAuditors);
        this.backendIDs = AuditDataSecurityTask.getStringList(backendIDs);
        this.reportFilters = AuditDataSecurityTask.getStringList(reportFilters);
        this.outputDirectory = outputDirectory;
        Validator.ensureTrue(this.includeAuditors.isEmpty() || this.excludeAuditors.isEmpty(), "You cannot request both include and exclude auditors.");
    }

    public AuditDataSecurityTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.includeAuditors = Collections.unmodifiableList(StaticUtils.toNonNullList(entry.getAttributeValues(ATTR_INCLUDE_AUDITOR)));
        this.excludeAuditors = Collections.unmodifiableList(StaticUtils.toNonNullList(entry.getAttributeValues(ATTR_EXCLUDE_AUDITOR)));
        this.backendIDs = Collections.unmodifiableList(StaticUtils.toNonNullList(entry.getAttributeValues(ATTR_BACKEND_ID)));
        this.reportFilters = Collections.unmodifiableList(StaticUtils.toNonNullList(entry.getAttributeValues(ATTR_REPORT_FILTER)));
        this.outputDirectory = entry.getAttributeValue(ATTR_OUTPUT_DIRECTORY);
    }

    public AuditDataSecurityTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(AUDIT_DATA_SECURITY_TASK_CLASS, properties);
        String outputDir = null;
        LinkedList<String> includeAuditorsList = new LinkedList<String>();
        LinkedList<String> excludeAuditorsList = new LinkedList<String>();
        LinkedList<String> backendIDList = new LinkedList<String>();
        LinkedList<String> reportFilterList = new LinkedList<String>();
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            String[] s;
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            if (attrName.equals(ATTR_INCLUDE_AUDITOR)) {
                s = AuditDataSecurityTask.parseStrings(p, values, null);
                if (s == null) continue;
                includeAuditorsList.addAll(Arrays.asList(s));
                continue;
            }
            if (attrName.equals(ATTR_EXCLUDE_AUDITOR)) {
                s = AuditDataSecurityTask.parseStrings(p, values, null);
                if (s == null) continue;
                excludeAuditorsList.addAll(Arrays.asList(s));
                continue;
            }
            if (attrName.equals(ATTR_BACKEND_ID)) {
                s = AuditDataSecurityTask.parseStrings(p, values, null);
                if (s == null) continue;
                backendIDList.addAll(Arrays.asList(s));
                continue;
            }
            if (attrName.equals(ATTR_REPORT_FILTER)) {
                s = AuditDataSecurityTask.parseStrings(p, values, null);
                if (s == null) continue;
                reportFilterList.addAll(Arrays.asList(s));
                continue;
            }
            if (!attrName.equals(ATTR_OUTPUT_DIRECTORY)) continue;
            outputDir = AuditDataSecurityTask.parseString(p, values, null);
        }
        this.includeAuditors = Collections.unmodifiableList(includeAuditorsList);
        this.excludeAuditors = Collections.unmodifiableList(excludeAuditorsList);
        this.backendIDs = Collections.unmodifiableList(backendIDList);
        this.reportFilters = Collections.unmodifiableList(reportFilterList);
        this.outputDirectory = outputDir;
        if (!this.includeAuditors.isEmpty() && !this.excludeAuditors.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_AUDIT_DATA_SECURITY_BOTH_INCLUDE_AND_EXCLUDE_AUDITORS.get());
        }
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_AUDIT_DATA_SECURITY.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_AUDIT_DATA_SECURITY.get();
    }

    @NotNull
    public List<String> getIncludeAuditors() {
        return this.includeAuditors;
    }

    @NotNull
    public List<String> getExcludeAuditors() {
        return this.excludeAuditors;
    }

    @NotNull
    public List<String> getBackendIDs() {
        return this.backendIDs;
    }

    @NotNull
    public List<String> getReportFilterStrings() {
        return this.reportFilters;
    }

    @NotNull
    public List<Filter> getReportFilters() throws LDAPException {
        if (this.reportFilters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>(this.reportFilters.size());
        for (String filter : this.reportFilters) {
            filterList.add(Filter.create(filter));
        }
        return Collections.unmodifiableList(filterList);
    }

    @Nullable
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_AUDIT_DATA_SECURITY_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        if (!this.includeAuditors.isEmpty()) {
            attrList.add(new Attribute(ATTR_INCLUDE_AUDITOR, this.includeAuditors));
        }
        if (!this.excludeAuditors.isEmpty()) {
            attrList.add(new Attribute(ATTR_EXCLUDE_AUDITOR, this.excludeAuditors));
        }
        if (!this.backendIDs.isEmpty()) {
            attrList.add(new Attribute(ATTR_BACKEND_ID, this.backendIDs));
        }
        if (!this.reportFilters.isEmpty()) {
            attrList.add(new Attribute(ATTR_REPORT_FILTER, this.reportFilters));
        }
        if (this.outputDirectory != null) {
            attrList.add(new Attribute(ATTR_OUTPUT_DIRECTORY, this.outputDirectory));
        }
        return attrList;
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_INCLUDE_AUDITOR, PROPERTY_EXCLUDE_AUDITOR, PROPERTY_BACKEND_ID, PROPERTY_REPORT_FILTER, PROPERTY_OUTPUT_DIRECTORY));
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<String>> props = new LinkedHashMap<TaskProperty, List<String>>(StaticUtils.computeMapCapacity(5));
        if (!this.includeAuditors.isEmpty()) {
            props.put(PROPERTY_INCLUDE_AUDITOR, Collections.unmodifiableList(this.includeAuditors));
        }
        if (!this.excludeAuditors.isEmpty()) {
            props.put(PROPERTY_EXCLUDE_AUDITOR, Collections.unmodifiableList(this.excludeAuditors));
        }
        if (!this.backendIDs.isEmpty()) {
            props.put(PROPERTY_BACKEND_ID, Collections.unmodifiableList(this.backendIDs));
        }
        if (!this.reportFilters.isEmpty()) {
            props.put(PROPERTY_REPORT_FILTER, Collections.unmodifiableList(this.reportFilters));
        }
        if (this.outputDirectory != null) {
            props.put(PROPERTY_OUTPUT_DIRECTORY, Collections.singletonList(this.outputDirectory));
        }
        return Collections.unmodifiableMap(props);
    }

    @NotNull
    private static List<String> getStringList(@Nullable List<String> l) {
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }
}

