/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.SearchResultOption;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.ESearchResponse;
import org.apache.james.mailbox.ModSeq;

public class ESearchResponseEncoder
implements ImapResponseEncoder<ESearchResponse> {
    @Override
    public Class<ESearchResponse> acceptableMessages() {
        return ESearchResponse.class;
    }

    @Override
    public void encode(ESearchResponse response, ImapResponseComposer composer) throws IOException {
        Tag tag = response.getTag();
        long min = response.getMinUid();
        long max = response.getMaxUid();
        long count = response.getCount();
        IdRange[] all = response.getAll();
        boolean useUid = response.getUseUid();
        ModSeq highestModSeq = response.getHighestModSeq();
        List<SearchResultOption> options = response.getSearchResultOptions();
        composer.untagged().message("ESEARCH").openParen().message("TAG").quote(tag.asString()).closeParen();
        if (useUid) {
            composer.message(ImapConstants.UID);
        }
        if (min > -1L && options.contains((Object)SearchResultOption.MIN)) {
            composer.message(SearchResultOption.MIN.name()).message(min);
        }
        if (max > -1L && options.contains((Object)SearchResultOption.MAX)) {
            composer.message(SearchResultOption.MAX.name()).message(max);
        }
        if (options.contains((Object)SearchResultOption.COUNT)) {
            composer.message(SearchResultOption.COUNT.name()).message(count);
        }
        if (all != null && all.length > 0 && options.contains((Object)SearchResultOption.ALL)) {
            composer.message(SearchResultOption.ALL.name());
            composer.sequenceSet(all);
        }
        if (highestModSeq != null) {
            composer.message(ImapConstants.FETCH_MODSEQ);
            composer.message(highestModSeq.asLong());
        }
        composer.end();
    }
}

