/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.CreationMessageId;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.message.view.MessageFullView;
import org.apache.james.mailbox.model.MessageId;

public class SetMessagesResponse
implements Method.Response {
    private final String accountId;
    private final String oldState;
    private final String newState;
    private final ImmutableMap<CreationMessageId, MessageFullView> created;
    private final ImmutableMap<CreationMessageId, MessageId> mdnSent;
    private final ImmutableList<MessageId> updated;
    private final ImmutableList<MessageId> destroyed;
    private final ImmutableMap<CreationMessageId, SetError> notCreated;
    private final ImmutableMap<CreationMessageId, SetError> mdnNotSent;
    private final ImmutableMap<MessageId, SetError> notUpdated;
    private final ImmutableMap<MessageId, SetError> notDestroyed;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    SetMessagesResponse(String accountId, String oldState, String newState, ImmutableMap<CreationMessageId, MessageFullView> created, ImmutableMap<CreationMessageId, MessageId> mdnSent, ImmutableList<MessageId> updated, ImmutableList<MessageId> destroyed, ImmutableMap<CreationMessageId, SetError> notCreated, ImmutableMap<CreationMessageId, SetError> mdnNotSent, ImmutableMap<MessageId, SetError> notUpdated, ImmutableMap<MessageId, SetError> notDestroyed) {
        this.accountId = accountId;
        this.oldState = oldState;
        this.newState = newState;
        this.created = created;
        this.mdnSent = mdnSent;
        this.updated = updated;
        this.destroyed = destroyed;
        this.notCreated = notCreated;
        this.mdnNotSent = mdnNotSent;
        this.notUpdated = notUpdated;
        this.notDestroyed = notDestroyed;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getOldState() {
        return this.oldState;
    }

    public String getNewState() {
        return this.newState;
    }

    public ImmutableMap<CreationMessageId, MessageFullView> getCreated() {
        return this.created;
    }

    public ImmutableList<MessageId> getUpdated() {
        return this.updated;
    }

    public ImmutableList<MessageId> getDestroyed() {
        return this.destroyed;
    }

    public ImmutableMap<CreationMessageId, SetError> getNotCreated() {
        return this.notCreated;
    }

    public ImmutableMap<MessageId, SetError> getNotUpdated() {
        return this.notUpdated;
    }

    public ImmutableMap<MessageId, SetError> getNotDestroyed() {
        return this.notDestroyed;
    }

    @JsonProperty(value="MDNSent")
    public ImmutableMap<CreationMessageId, MessageId> getMDNSent() {
        return this.mdnSent;
    }

    @JsonProperty(value="MDNNotSent")
    public ImmutableMap<CreationMessageId, SetError> getMDNNotSent() {
        return this.mdnNotSent;
    }

    public Builder mergeInto(Builder responseBuilder) {
        responseBuilder.created((Map<CreationMessageId, MessageFullView>)this.getCreated());
        responseBuilder.updated((List<MessageId>)this.getUpdated());
        responseBuilder.destroyed((List<MessageId>)this.getDestroyed());
        responseBuilder.notCreated((Map<CreationMessageId, SetError>)this.getNotCreated());
        responseBuilder.notUpdated((Map<MessageId, SetError>)this.getNotUpdated());
        responseBuilder.notDestroyed((Map<MessageId, SetError>)this.getNotDestroyed());
        responseBuilder.mdnNotSent((Map<CreationMessageId, SetError>)this.getMDNNotSent());
        responseBuilder.mdnSent(this.getMDNSent());
        if (!Strings.isNullOrEmpty((String)this.getAccountId())) {
            responseBuilder.accountId(this.getAccountId());
        }
        if (!Strings.isNullOrEmpty((String)this.getOldState())) {
            responseBuilder.accountId(this.getOldState());
        }
        if (!Strings.isNullOrEmpty((String)this.getNewState())) {
            responseBuilder.accountId(this.getAccountId());
        }
        return responseBuilder;
    }

    public static class Builder {
        private String accountId;
        private String oldState;
        private String newState;
        private final ImmutableMap.Builder<CreationMessageId, MessageFullView> created = ImmutableMap.builder();
        private final ImmutableMap.Builder<CreationMessageId, MessageId> mdnSent = ImmutableMap.builder();
        private final ImmutableList.Builder<MessageId> updated = ImmutableList.builder();
        private final ImmutableList.Builder<MessageId> destroyed = ImmutableList.builder();
        private final ImmutableMap.Builder<CreationMessageId, SetError> notCreated = ImmutableMap.builder();
        private final ImmutableMap.Builder<CreationMessageId, SetError> mdnNotSent = ImmutableMap.builder();
        private final ImmutableMap.Builder<MessageId, SetError> notUpdated = ImmutableMap.builder();
        private final ImmutableMap.Builder<MessageId, SetError> notDestroyed = ImmutableMap.builder();

        public static Builder accumulator(Builder accumulator, SetMessagesResponse response) {
            return response.mergeInto(accumulator);
        }

        public static Builder combiner(Builder firstBuilder, Builder secondBuilder) {
            return secondBuilder.build().mergeInto(firstBuilder);
        }

        private Builder() {
        }

        public Builder accountId(String accountId) {
            throw new NotImplementedException("not implemented");
        }

        public Builder oldState(String oldState) {
            throw new NotImplementedException("not implemented");
        }

        public Builder newState(String newState) {
            throw new NotImplementedException("not implemented");
        }

        public Builder created(CreationMessageId creationMessageId, MessageFullView message) {
            this.created.put((Object)creationMessageId, (Object)message);
            return this;
        }

        public Builder created(Map<CreationMessageId, MessageFullView> created) {
            this.created.putAll(created);
            return this;
        }

        public Builder mdnSent(CreationMessageId creationMessageId, MessageId messageId) {
            this.mdnSent.put((Object)creationMessageId, (Object)messageId);
            return this;
        }

        public Builder mdnSent(ImmutableMap<CreationMessageId, MessageId> sent) {
            this.mdnSent.putAll(sent);
            return this;
        }

        public Builder updated(List<MessageId> updated) {
            this.updated.addAll(updated);
            return this;
        }

        public Builder destroyed(MessageId destroyed) {
            this.destroyed.add((Object)destroyed);
            return this;
        }

        public Builder destroyed(List<MessageId> destroyed) {
            this.destroyed.addAll(destroyed);
            return this;
        }

        public Builder notCreated(Map<CreationMessageId, SetError> notCreated) {
            this.notCreated.putAll(notCreated);
            return this;
        }

        public Builder mdnNotSent(Map<CreationMessageId, SetError> notCreated) {
            this.mdnNotSent.putAll(notCreated);
            return this;
        }

        public Builder mdnNotSent(CreationMessageId creationMessageId, SetError error) {
            this.mdnNotSent.put((Object)creationMessageId, (Object)error);
            return this;
        }

        public Builder notCreated(CreationMessageId id, SetError error) {
            this.notCreated.put((Object)id, (Object)error);
            return this;
        }

        public Builder notUpdated(Map<MessageId, SetError> notUpdated) {
            this.notUpdated.putAll(notUpdated);
            return this;
        }

        public Builder notUpdated(MessageId messageId, SetError error) {
            this.notUpdated.put((Object)messageId, (Object)error);
            return this;
        }

        public Builder notDestroyed(MessageId messageId, SetError notDestroyed) {
            this.notDestroyed.put((Object)messageId, (Object)notDestroyed);
            return this;
        }

        public Builder notDestroyed(Map<MessageId, SetError> notDestroyed) {
            this.notDestroyed.putAll(notDestroyed);
            return this;
        }

        public Builder mergeWith(Builder otherBuilder) {
            return otherBuilder.build().mergeInto(this);
        }

        public SetMessagesResponse build() {
            return new SetMessagesResponse(this.accountId, this.oldState, this.newState, (ImmutableMap<CreationMessageId, MessageFullView>)this.created.build(), (ImmutableMap<CreationMessageId, MessageId>)this.mdnSent.build(), (ImmutableList<MessageId>)this.updated.build(), (ImmutableList<MessageId>)this.destroyed.build(), (ImmutableMap<CreationMessageId, SetError>)this.notCreated.build(), (ImmutableMap<CreationMessageId, SetError>)this.mdnNotSent.build(), (ImmutableMap<MessageId, SetError>)this.notUpdated.build(), (ImmutableMap<MessageId, SetError>)this.notDestroyed.build());
        }
    }
}

