/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.AccessibleById;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface GettableById
extends GettableByIndex,
AccessibleById {
    @Nullable
    default public ByteBuffer getBytesUnsafe(@NonNull CqlIdentifier id) {
        return this.getBytesUnsafe(this.firstIndexOf(id));
    }

    default public boolean isNull(@NonNull CqlIdentifier id) {
        return this.isNull(this.firstIndexOf(id));
    }

    @Nullable
    default public <ValueT> ValueT get(@NonNull CqlIdentifier id, @NonNull TypeCodec<ValueT> codec) {
        return this.get(this.firstIndexOf(id), codec);
    }

    @Nullable
    default public <ValueT> ValueT get(@NonNull CqlIdentifier id, @NonNull GenericType<ValueT> targetType) {
        return this.get(this.firstIndexOf(id), targetType);
    }

    @Nullable
    default public <ValueT> ValueT get(@NonNull CqlIdentifier id, @NonNull Class<ValueT> targetClass) {
        return this.get(this.firstIndexOf(id), targetClass);
    }

    @Nullable
    default public Object getObject(@NonNull CqlIdentifier id) {
        return this.getObject(this.firstIndexOf(id));
    }

    default public boolean getBoolean(@NonNull CqlIdentifier id) {
        return this.getBoolean(this.firstIndexOf(id));
    }

    @Deprecated
    default public boolean getBool(@NonNull CqlIdentifier id) {
        return this.getBoolean(id);
    }

    default public byte getByte(@NonNull CqlIdentifier id) {
        return this.getByte(this.firstIndexOf(id));
    }

    default public double getDouble(@NonNull CqlIdentifier id) {
        return this.getDouble(this.firstIndexOf(id));
    }

    default public float getFloat(@NonNull CqlIdentifier id) {
        return this.getFloat(this.firstIndexOf(id));
    }

    default public int getInt(@NonNull CqlIdentifier id) {
        return this.getInt(this.firstIndexOf(id));
    }

    default public long getLong(@NonNull CqlIdentifier id) {
        return this.getLong(this.firstIndexOf(id));
    }

    default public short getShort(@NonNull CqlIdentifier id) {
        return this.getShort(this.firstIndexOf(id));
    }

    @Nullable
    default public Instant getInstant(@NonNull CqlIdentifier id) {
        return this.getInstant(this.firstIndexOf(id));
    }

    @Nullable
    default public LocalDate getLocalDate(@NonNull CqlIdentifier id) {
        return this.getLocalDate(this.firstIndexOf(id));
    }

    @Nullable
    default public LocalTime getLocalTime(@NonNull CqlIdentifier id) {
        return this.getLocalTime(this.firstIndexOf(id));
    }

    @Nullable
    default public ByteBuffer getByteBuffer(@NonNull CqlIdentifier id) {
        return this.getByteBuffer(this.firstIndexOf(id));
    }

    @Nullable
    default public String getString(@NonNull CqlIdentifier id) {
        return this.getString(this.firstIndexOf(id));
    }

    @Nullable
    default public BigInteger getBigInteger(@NonNull CqlIdentifier id) {
        return this.getBigInteger(this.firstIndexOf(id));
    }

    @Nullable
    default public BigDecimal getBigDecimal(@NonNull CqlIdentifier id) {
        return this.getBigDecimal(this.firstIndexOf(id));
    }

    @Nullable
    default public UUID getUuid(@NonNull CqlIdentifier id) {
        return this.getUuid(this.firstIndexOf(id));
    }

    @Nullable
    default public InetAddress getInetAddress(@NonNull CqlIdentifier id) {
        return this.getInetAddress(this.firstIndexOf(id));
    }

    @Nullable
    default public CqlDuration getCqlDuration(@NonNull CqlIdentifier id) {
        return this.getCqlDuration(this.firstIndexOf(id));
    }

    @Nullable
    default public Token getToken(@NonNull CqlIdentifier id) {
        return this.getToken(this.firstIndexOf(id));
    }

    @Nullable
    default public <ElementT> List<ElementT> getList(@NonNull CqlIdentifier id, @NonNull Class<ElementT> elementsClass) {
        return this.getList(this.firstIndexOf(id), elementsClass);
    }

    @Nullable
    default public <ElementT> Set<ElementT> getSet(@NonNull CqlIdentifier id, @NonNull Class<ElementT> elementsClass) {
        return this.getSet(this.firstIndexOf(id), elementsClass);
    }

    @Nullable
    default public <KeyT, ValueT> Map<KeyT, ValueT> getMap(@NonNull CqlIdentifier id, @NonNull Class<KeyT> keyClass, @NonNull Class<ValueT> valueClass) {
        return this.getMap(this.firstIndexOf(id), keyClass, valueClass);
    }

    @Nullable
    default public UdtValue getUdtValue(@NonNull CqlIdentifier id) {
        return this.getUdtValue(this.firstIndexOf(id));
    }

    @Nullable
    default public TupleValue getTupleValue(@NonNull CqlIdentifier id) {
        return this.getTupleValue(this.firstIndexOf(id));
    }
}

