/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractGeometryCodec;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.codec.Polygon;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import java.util.ArrayList;
import java.util.List;

final class PolygonCodec
extends AbstractGeometryCodec<Polygon> {
    PolygonCodec(ByteBufAllocator byteBufAllocator) {
        super(Polygon.class, PostgresqlObjectId.POLYGON, byteBufAllocator);
    }

    @Override
    Polygon doDecodeBinary(ByteBuf byteBuffer) {
        int size = byteBuffer.readInt();
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < size; ++i) {
            points.add(Point.of(byteBuffer.readDouble(), byteBuffer.readDouble()));
        }
        return Polygon.of(points);
    }

    @Override
    Polygon doDecodeText(String text) {
        AbstractGeometryCodec.TokenStream stream = this.getTokenStream(text);
        ArrayList<Point> points = new ArrayList<Point>();
        while (stream.hasNext()) {
            points.add(Point.of(stream.nextDouble(), stream.nextDouble()));
        }
        return Polygon.of(points);
    }

    @Override
    ByteBuf doEncodeBinary(Polygon value) {
        List<Point> points = value.getPoints();
        ByteBuf buffer = this.byteBufAllocator.buffer(points.size() * 16 + 4).writeInt(points.size());
        points.forEach(point -> buffer.writeDouble(point.getX()).writeDouble(point.getY()));
        return buffer;
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.POLYGON_ARRAY;
    }
}

