/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Limit$;
import org.apache.james.jmap.core.Position$;
import org.apache.james.jmap.core.QueryState$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.json.MailboxQuerySerializer$;
import org.apache.james.jmap.mail.MailboxQueryRequest;
import org.apache.james.jmap.mail.MailboxQueryResponse;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.method.package$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\t\u0012\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011)\u0019!C\u0001k!Aa\b\u0001B\u0001B\u0003%a\u0007\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0011!9\u0005A!A!\u0002\u0013\t\u0005\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\t\u0011A\u0003!\u0011!Q\u0001\n)CQ!\u0015\u0001\u0005\u0002ICq!\u0019\u0001C\u0002\u0013\u0005#\r\u0003\u0004x\u0001\u0001\u0006Ia\u0019\u0005\bq\u0002\u0011\r\u0011\"\u0011z\u0011\u001d\t\u0019\u0002\u0001Q\u0001\niDq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002J\u0001!\t%a\u0013\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r\t\u0011R*Y5mE>D\u0018+^3ss6+G\u000f[8e\u0015\t\u00112#\u0001\u0004nKRDw\u000e\u001a\u0006\u0003)U\tAA[7ba*\u0011acF\u0001\u0006U\u0006lWm\u001d\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0004I\u0015:S\"A\t\n\u0005\u0019\n\"\u0001G'fi\"|GMU3rk&\u0014\u0018N\\4BG\u000e|WO\u001c;JIB\u0011\u0001fK\u0007\u0002S)\u0011!fE\u0001\u0005[\u0006LG.\u0003\u0002-S\t\u0019R*Y5mE>D\u0018+^3ssJ+\u0017/^3ti\u000692/_:uK6l\u0015-\u001b7c_b,7\u000f\u0015:pm&$WM\u001d\t\u0003_Ij\u0011\u0001\r\u0006\u0003cU\tq!\\1jY\n|\u00070\u0003\u00024a\t92+_:uK6l\u0015-\u001b7c_b,7\u000f\u0015:pm&$WM]\u0001\u000e[\u0016$(/[2GC\u000e$xN]=\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002<+\u00059Q.\u001a;sS\u000e\u001c\u0018BA\u001f9\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006qQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004\u0013aD:fgNLwN\\*vaBd\u0017.\u001a:\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001R\n\u0002\rI|W\u000f^3t\u0013\t15IA\bTKN\u001c\u0018n\u001c8TkB\u0004H.[3s\u0003A\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b%A\ttKN\u001c\u0018n\u001c8Ue\u0006t7\u000f\\1u_J,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bN\tAaY8sK&\u0011q\n\u0014\u0002\u0012'\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014\u0018AE:fgNLwN\u001c+sC:\u001cH.\u0019;pe\u0002\na\u0001P5oSRtD#B*U+Z;\u0006C\u0001\u0013\u0001\u0011\u0015i\u0003\u00021\u0001/\u0011\u0015!\u0004\u00021\u00017\u0011\u0015y\u0004\u00021\u0001B\u0011\u0015A\u0005\u00021\u0001KQ\tA\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u00061\u0011N\u001c6fGRT\u0011AX\u0001\bU\u0006\\\u0017M\u001d;b\u0013\t\u00017L\u0001\u0004J]*,7\r^\u0001\u000b[\u0016$\bn\u001c3OC6,W#A2\u0011\u0005\u0011$hBA3s\u001d\t1\u0017O\u0004\u0002ha:\u0011\u0001n\u001c\b\u0003S:t!A[7\u000e\u0003-T!\u0001\\\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002\u0015+%\u0011QjE\u0005\u0003g2\u000b!\"\u00138w_\u000e\fG/[8o\u0013\t)hO\u0001\u0006NKRDw\u000e\u001a(b[\u0016T!a\u001d'\u0002\u00175,G\u000f[8e\u001d\u0006lW\rI\u0001\u0015e\u0016\fX/\u001b:fI\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0016\u0003i\u0004Ba_@\u0002\u00069\u0011A0 \t\u0003U~I!A`\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0001\u0003\u0007M+GO\u0003\u0002\u007f?A!\u0011qAA\u0007\u001d\r)\u0017\u0011B\u0005\u0004\u0003\u0017a\u0015\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'/\u0003\u0003\u0002\u0010\u0005E!\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'OC\u0002\u0002\f1\u000bQC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\b%A\u0005e_B\u0013xnY3tgRQ\u0011\u0011DA\u001a\u0003o\tY$!\u0012\u0011\r\u0005m\u0011\u0011FA\u0017\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012!\u00039vE2L7\u000f[3s\u0015\r\u0001\u00131\u0005\u0006\u0004\u001b\u0006\u0015\"BAA\u0014\u0003\u001d\u0011X-Y2u_JLA!a\u000b\u0002\u001e\t)1+T8o_B\u0019A%a\f\n\u0007\u0005E\u0012CA\u000bJ]Z|7-\u0019;j_:<\u0016\u000e\u001e5D_:$X\r\u001f;\t\r\u0005UR\u00021\u0001{\u00031\u0019\u0017\r]1cS2LG/[3t\u0011\u001d\tI$\u0004a\u0001\u0003[\t!\"\u001b8w_\u000e\fG/[8o\u0011\u001d\ti$\u0004a\u0001\u0003\u007f\ta\"\\1jY\n|\u0007pU3tg&|g\u000eE\u00020\u0003\u0003J1!a\u00111\u00059i\u0015-\u001b7c_b\u001cVm]:j_:Da!a\u0012\u000e\u0001\u00049\u0013a\u0002:fcV,7\u000f^\u0001\u000bO\u0016$(+Z9vKN$HCBA'\u0003K\n9\u0007E\u0004\u0002P\u0005e\u0013qL\u0014\u000f\t\u0005E\u0013Q\u000b\b\u0004U\u0006M\u0013\"\u0001\u0011\n\u0007\u0005]s$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0013Q\f\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005]s\u0004\u0005\u0003\u0002P\u0005\u0005\u0014\u0002BA2\u0003;\u0012\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0011\u001d\tiD\u0004a\u0001\u0003\u007fAq!!\u000f\u000f\u0001\u0004\tI\u0007E\u0002L\u0003WJ1!!\u001cM\u0005)IeN^8dCRLwN\\\u0001\u000faJ|7-Z:t%\u0016\fX/Z:u)!\t\u0019(!\u001e\u0002x\u0005e\u0004CBA\u000e\u0003S\tI\u0007C\u0004\u0002>=\u0001\r!a\u0010\t\u000f\u0005er\u00021\u0001\u0002j!1\u0011qI\bA\u0002\u001d\u0002")
public class MailboxQueryMethod
implements MethodRequiringAccountId<MailboxQueryRequest> {
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, MailboxQueryRequest request) {
        return this.processRequest(mailboxSession, invocation.invocation(), request).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return SMono$.MODULE$.error(throwable2);
            }
            throw new MatchError((Object)throwable);
        }).map((Function1 & Serializable)invocationResult -> new InvocationWithContext((Invocation)invocationResult, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, MailboxQueryRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return package$.MODULE$.AsEitherRequest(MailboxQuerySerializer$.MODULE$.deserialize((JsValue)invocation.arguments())).asEitherRequest();
    }

    private SMono<Invocation> processRequest(MailboxSession mailboxSession, Invocation invocation, MailboxQueryRequest request) {
        return SFlux$.MODULE$.fromPublisher(this.systemMailboxesProvider.getMailboxByRole(request.filter().role(), mailboxSession.getUser())).map((Function1 & Serializable)x$1 -> x$1.getId()).collectSeq().map((Function1 & Serializable)ids -> new MailboxQueryResponse(request.accountId(), QueryState$.MODULE$.forMailboxIds((Seq<MailboxId>)ids), false, (Seq)ids, Position$.MODULE$.zero(), (Option)new Some((Object)new Refined((Object)Limit$.MODULE$.default())))).map((Function1 & Serializable)response -> new Invocation(this.methodName(), MailboxQuerySerializer$.MODULE$.serialize((MailboxQueryResponse)response), invocation.methodCallId()));
    }

    @Inject
    public MailboxQueryMethod(SystemMailboxesProvider systemMailboxesProvider, MetricFactory metricFactory, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator) {
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Mailbox/query")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

