/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeDataDefinition;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.server.task.json.JsonTaskAdditionalInformationSerializer;
import org.apache.james.task.Hostname;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskType;
import org.apache.james.task.eventsourcing.cassandra.CassandraTaskExecutionDetailsProjectionTable$;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u000e\u001d\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A1\n\u0001B\u0001B\u0003%A\nC\u0003V\u0001\u0011\u0005a\u000bC\u0004f\u0001\t\u0007I\u0011\u00024\t\r5\u0004\u0001\u0015!\u0003h\u0011\u001dq\u0007A1A\u0005\n=DaA\u001e\u0001!\u0002\u0013\u0001\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011B=\t\u0011\u0005\u0005\u0001A1A\u0005\naDq!a\u0001\u0001A\u0003%\u0011\u0010\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003y\u0011\u001d\t9\u0001\u0001Q\u0001\neD\u0001\"!\u0003\u0001\u0005\u0004%I\u0001\u001f\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003z\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003w\u0003A\u0011AA_\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002d\u0002!I!!:\u0003U\r\u000b7o]1oIJ\fG+Y:l\u000bb,7-\u001e;j_:$U\r^1jYN\u0004&o\u001c6fGRLwN\u001c#B\u001f*\u0011QDH\u0001\nG\u0006\u001c8/\u00198ee\u0006T!a\b\u0011\u0002\u001b\u00154XM\u001c;t_V\u00148-\u001b8h\u0015\t\t#%\u0001\u0003uCN\\'BA\u0012%\u0003\u0015Q\u0017-\\3t\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0002\u000fM,7o]5p]B\u0011!gP\u0007\u0002g)\u0011A'N\u0001\u0005G>\u0014XM\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014A\u00023sSZ,'O\u0003\u0002;w\u0005\u0019qn]:\u000b\u0005qj\u0014\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003y\n1aY8n\u0013\t\u00015G\u0001\u0006Dc2\u001cVm]:j_:\fQ\u0002^=qKN\u0004&o\u001c<jI\u0016\u0014\bCA\"J\u001b\u0005!%BA#G\u0003\u0011Ig.\u001b;\u000b\u0005u9%B\u0001%#\u0003!\u0011\u0017mY6f]\u0012\u001c\u0018B\u0001&E\u0005Y\u0019\u0015m]:b]\u0012\u0014\u0018\rV=qKN\u0004&o\u001c<jI\u0016\u0014\u0018a\n6t_:$\u0016m]6BI\u0012LG/[8oC2LeNZ8s[\u0006$\u0018n\u001c8TKJL\u0017\r\\5{KJ\u0004\"!T*\u000e\u00039S!a\u0014)\u0002\t)\u001cxN\u001c\u0006\u0003CES!A\u0015\u0012\u0002\rM,'O^3s\u0013\t!fJA\u0014Kg>tG+Y:l\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017J\u001c4pe6\fG/[8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003X3j[\u0006C\u0001-\u0001\u001b\u0005a\u0002\"\u0002\u0019\u0005\u0001\u0004\t\u0004\"B!\u0005\u0001\u0004\u0011\u0005\"B&\u0005\u0001\u0004a\u0005F\u0001\u0003^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0004j]*,7\r\u001e\u0006\u0002E\u00069!.Y6beR\f\u0017B\u00013`\u0005\u0019IeN[3di\u000612-Y:tC:$'/Y!ts:\u001cW\t_3dkR|'/F\u0001h!\tA7.D\u0001j\u0015\tQg)A\u0003vi&d7/\u0003\u0002mS\n12)Y:tC:$'/Y!ts:\u001cW\t_3dkR|'/A\fdCN\u001c\u0018M\u001c3sC\u0006\u001b\u0018P\\2Fq\u0016\u001cW\u000f^8sA\u0005AA-\u0019;f)f\u0004X-F\u0001q!\t\tH/D\u0001s\u0015\t\u00198'\u0001\u0003usB,\u0017BA;s\u0005=)6/\u001a:EK\u001aLg.\u001a3UsB,\u0017!\u00033bi\u0016$\u0016\u0010]3!\u0003=Ign]3siN#\u0018\r^3nK:$X#A=\u0011\u0005ilX\"A>\u000b\u0005q\u001c\u0014aA2rY&\u0011ap\u001f\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\u0018\u0001E5og\u0016\u0014Ho\u0015;bi\u0016lWM\u001c;!\u0003=\u0019X\r\\3diN#\u0018\r^3nK:$\u0018\u0001E:fY\u0016\u001cGo\u0015;bi\u0016lWM\u001c;!\u00035a\u0017n\u001d;Ti\u0006$X-\\3oi\u0006qA.[:u'R\fG/Z7f]R\u0004\u0013a\u0004:f[>4Xm\u0015;bi\u0016lWM\u001c;\u0002!I,Wn\u001c<f'R\fG/Z7f]R\u0004\u0013aC:bm\u0016$U\r^1jYN$B!!\u0005\u00024A1\u00111CA\u0010\u0003Gi!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\naV\u0014G.[:iKJT1\u0001NA\u000e\u0015\t\ti\"A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005\u0005\u0012Q\u0003\u0002\u0005\u001b>tw\u000e\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\t1\fgn\u001a\u0006\u0003\u0003[\tAA[1wC&!\u0011\u0011GA\u0014\u0005\u00111v.\u001b3\t\u000f\u0005U\u0012\u00031\u0001\u00028\u00059A-\u001a;bS2\u001c\b\u0003BA\u001d\u0003wi\u0011\u0001I\u0005\u0004\u0003{\u0001#\u0001\u0006+bg.,\u00050Z2vi&|g\u000eR3uC&d7/A\fcS:$w\n\u001d;j_:\fGn\u0015;sS:<g+\u00197vKRA\u00111IA%\u0003\u001b\n9\u0007E\u0002{\u0003\u000bJ1!a\u0012|\u00059\u0011u.\u001e8e'R\fG/Z7f]RDq!a\u0013\u0013\u0001\u0004\t\u0019%A\u0005ti\u0006$X-\\3oi\"9\u0011q\n\nA\u0002\u0005E\u0013!\u00034jK2$g*Y7f!\u0011\t\u0019&!\u0019\u000f\t\u0005U\u0013Q\f\t\u0004\u0003/bSBAA-\u0015\r\tY\u0006K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}C&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\n)G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?b\u0003bBA5%\u0001\u0007\u00111N\u0001\u000bM&,G\u000e\u001a,bYV,\u0007CBA7\u0003g\n\t&\u0004\u0002\u0002p)!\u0011\u0011OA\u0016\u0003\u0011)H/\u001b7\n\t\u0005U\u0014q\u000e\u0002\t\u001fB$\u0018n\u001c8bY\u0006!\"-\u001b8e\u001fB$\u0018n\u001c8bYV#EKV1mk\u0016$\u0002\"a\u0011\u0002|\u0005u\u0014q\u0010\u0005\b\u0003\u0017\u001a\u0002\u0019AA\"\u0011\u001d\tye\u0005a\u0001\u0003#Bq!!\u001b\u0014\u0001\u0004\t\t\t\u0005\u0004\u0002n\u0005M\u00141\u0011\t\u0005\u0003\u000b\u000bY)\u0004\u0002\u0002\b*\u0019\u0011\u0011R\u001a\u0002\t\u0011\fG/Y\u0005\u0005\u0003\u001b\u000b9I\u0001\u0005VIR4\u0016\r\\;f\u0003y\u0019XM]5bY&TX-\u00113eSRLwN\\1m\u0013:4wN]7bi&|g\u000e\u0006\u0003\u0002\u0014\u0006}\u0005CBAK\u00037\u000bY'\u0004\u0002\u0002\u0018*!\u0011qCAM\u0015\ri\u0013\u0011D\u0005\u0005\u0003;\u000b9JA\u0003T\u001b>tw\u000eC\u0004\u00026Q\u0001\r!a\u000e\u0002\u0017I,\u0017\r\u001a#fi\u0006LGn\u001d\u000b\u0005\u0003K\u000b9\u000b\u0005\u0004\u0002\u0014\u0005}\u0011q\u0007\u0005\b\u0003S+\u0002\u0019AAV\u0003\u0019!\u0018m]6JIB!\u0011\u0011HAW\u0013\r\ty\u000b\t\u0002\u0007)\u0006\u001c8.\u00133\u0002\u00171L7\u000f\u001e#fi\u0006LGn\u001d\u000b\u0003\u0003k\u0003b!a\u0005\u00028\u0006]\u0012\u0002BA]\u0003+\u0011AA\u00127vq\u00069B.[:u\t\u0016$\u0018-\u001b7t\u0005f\u0014UMZ8sK\u0012\u000bG/\u001a\u000b\u0005\u0003k\u000by\fC\u0004\u0002B^\u0001\r!a1\u0002\u0015\t,gm\u001c:f\t\u0006$X\r\u0005\u0003\u0002F\u0006-WBAAd\u0015\u0011\tI-a\u000b\u0002\tQLW.Z\u0005\u0005\u0003\u001b\f9MA\u0004J]N$\u0018M\u001c;\u0002\rI,Wn\u001c<f)\u0011\t\t\"a5\t\u000f\u0005U\u0002\u00041\u0001\u00028\u00059!/Z1e%><H\u0003BA\u001c\u00033Dq!a7\u001a\u0001\u0004\ti.A\u0002s_^\u00042A_Ap\u0013\r\t\to\u001f\u0002\u0004%><\u0018\u0001\t3fg\u0016\u0014\u0018.\u00197ju\u0016\fE\rZ5uS>t\u0017\r\\%oM>\u0014X.\u0019;j_:$b!a:\u0002x\n\u0005\u0001CBA7\u0003g\nI\u000f\u0005\u0003\u0002l\u0006Eh\u0002BA\u001d\u0003[L1!a<!\u0003Q!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0012+G/Y5mg&!\u00111_A{\u0005U\tE\rZ5uS>t\u0017\r\\%oM>\u0014X.\u0019;j_:T1!a<!\u0011\u001d\tIP\u0007a\u0001\u0003w\f\u0001\u0002^1tWRK\b/\u001a\t\u0005\u0003s\ti0C\u0002\u0002\u0000\u0002\u0012\u0001\u0002V1tWRK\b/\u001a\u0005\b\u00037T\u0002\u0019AAo\u0001")
public class CassandraTaskExecutionDetailsProjectionDAO {
    private final JsonTaskAdditionalInformationSerializer jsonTaskAdditionalInformationSerializer;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final UserDefinedType dateType;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement removeStatement;

    private CassandraAsyncExecutor cassandraAsyncExecutor() {
        return this.cassandraAsyncExecutor;
    }

    private UserDefinedType dateType() {
        return this.dateType;
    }

    private PreparedStatement insertStatement() {
        return this.insertStatement;
    }

    private PreparedStatement selectStatement() {
        return this.selectStatement;
    }

    private PreparedStatement listStatement() {
        return this.listStatement;
    }

    private PreparedStatement removeStatement() {
        return this.removeStatement;
    }

    public Mono<Void> saveDetails(TaskExecutionDetails details) {
        return Mono.from((Publisher)this.serializeAdditionalInformation(details).flatMap((Function1 & Serializable)serializeAdditionalInformation -> {
            BoundStatement boundStatement = (BoundStatement)this.insertStatement().bind(new Object[0]).setUuid(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), details.getTaskId().getValue()).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE(), details.getType().asString()).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS(), details.getStatus().getValue()).setUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE(), CassandraZonedDateTimeDataDefinition.toUDT((UserDefinedType)this.dateType(), (ZonedDateTime)details.getSubmittedDate())).setString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE(), details.getSubmittedNode().asString());
            .colon.colon bindOptionalFieldOperations = new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE(), CassandraZonedDateTimeDataDefinition.toUDT((UserDefinedType)this.dateType(), (Optional)details.getStartedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE(), details.getRanNode().map(x$1 -> x$1.asString())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE(), CassandraZonedDateTimeDataDefinition.toUDT((UserDefinedType)this.dateType(), (Optional)details.getCompletedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE(), CassandraZonedDateTimeDataDefinition.toUDT((UserDefinedType)this.dateType(), (Optional)details.getCanceledDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE(), details.getCancelRequestedNode().map(x$2 -> x$2.asString())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalUDTValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE(), CassandraZonedDateTimeDataDefinition.toUDT((UserDefinedType)this.dateType(), (Optional)details.getFailedDate())), (List)new .colon.colon((Function1 & Serializable)statement -> this.bindOptionalStringValue((BoundStatement)statement, CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION(), (Optional<String>)serializeAdditionalInformation), (List)Nil$.MODULE$)))))));
            BoundStatement fullyBoundStatement = (BoundStatement)bindOptionalFieldOperations.foldLeft((Object)boundStatement, (Function2 & Serializable)(statement, bindFieldOperation) -> (BoundStatement)bindFieldOperation.apply(statement));
            return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeVoid((Statement)fullyBoundStatement));
        }));
    }

    private BoundStatement bindOptionalStringValue(BoundStatement statement, String fieldName, Optional<String> fieldValue) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(fieldValue));
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return (BoundStatement)statement.setString(fieldName, value);
        }
        if (None$.MODULE$.equals(option)) {
            return statement;
        }
        throw new MatchError((Object)option);
    }

    private BoundStatement bindOptionalUDTValue(BoundStatement statement, String fieldName, Optional<UdtValue> fieldValue) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(fieldValue));
        if (option instanceof Some) {
            Some some = (Some)option;
            UdtValue value = (UdtValue)some.value();
            return (BoundStatement)statement.setUdtValue(fieldName, value);
        }
        if (None$.MODULE$.equals(option)) {
            return statement;
        }
        throw new MatchError((Object)option);
    }

    private SMono<Optional<String>> serializeAdditionalInformation(TaskExecutionDetails details) {
        return SMono$.MODULE$.fromCallable(() -> details.getAdditionalInformation().map(x$3 -> $this.jsonTaskAdditionalInformationSerializer.serialize(x$3))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public Mono<TaskExecutionDetails> readDetails(TaskId taskId) {
        return this.cassandraAsyncExecutor().executeSingleRow((Statement)this.selectStatement().bind(new Object[0]).setUuid(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), taskId.getValue())).map(row -> this.readRow((Row)row));
    }

    public Flux<TaskExecutionDetails> listDetails() {
        return this.cassandraAsyncExecutor().executeRows((Statement)this.listStatement().bind(new Object[0])).map(row -> this.readRow((Row)row));
    }

    public Flux<TaskExecutionDetails> listDetailsByBeforeDate(Instant beforeDate) {
        return this.listDetails().filter(detail -> detail.getSubmittedDate().toInstant().isBefore(beforeDate));
    }

    public Mono<Void> remove(TaskExecutionDetails details) {
        return this.cassandraAsyncExecutor().executeVoid((Statement)this.removeStatement().bind(new Object[0]).setUuid(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), details.getTaskId().getValue()));
    }

    private TaskExecutionDetails readRow(Row row) {
        TaskType taskType = TaskType.of((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE()));
        TaskId x$1 = TaskId.fromUUID((UUID)row.getUuid(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()));
        TaskType x$2 = TaskType.of((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE()));
        TaskManager.Status x$3 = TaskManager.Status.fromString((String)row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS()));
        ZonedDateTime x$42 = CassandraZonedDateTimeDataDefinition.fromUDT((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE()));
        Hostname x$52 = new Hostname(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE()));
        Optional x$6 = CassandraZonedDateTimeDataDefinition.fromUDTOptional((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE()));
        Optional<Hostname> x$7 = Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE())).map(x$4 -> new Hostname(x$4));
        Optional x$8 = CassandraZonedDateTimeDataDefinition.fromUDTOptional((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE()));
        Optional x$9 = CassandraZonedDateTimeDataDefinition.fromUDTOptional((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE()));
        Optional<Hostname> x$10 = Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE())).map(x$5 -> new Hostname(x$5));
        Optional x$11 = CassandraZonedDateTimeDataDefinition.fromUDTOptional((UdtValue)row.getUdtValue(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE()));
        Function0 & Serializable x$12 = (Function0 & Serializable)() -> this.deserializeAdditionalInformation(taskType, row);
        return new TaskExecutionDetails(x$1, x$2, x$3, x$42, x$52, (Function0)x$12, x$6, x$7, x$8, x$9, x$10, x$11);
    }

    private Optional<TaskExecutionDetails.AdditionalInformation> deserializeAdditionalInformation(TaskType taskType, Row row) {
        return Optional.ofNullable(row.getString(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION())).map(additionalInformation -> $this.jsonTaskAdditionalInformationSerializer.deserialize(additionalInformation));
    }

    @Inject
    public CassandraTaskExecutionDetailsProjectionDAO(CqlSession session, CassandraTypesProvider typesProvider, JsonTaskAdditionalInformationSerializer jsonTaskAdditionalInformationSerializer) {
        this.jsonTaskAdditionalInformationSerializer = jsonTaskAdditionalInformationSerializer;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.dateType = typesProvider.getDefinedUserType("zonedDateTime");
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TYPE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STATUS())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.SUBMITTED_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.STARTED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.RAN_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.COMPLETED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCELED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.CANCEL_REQUESTED_NODE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.FAILED_DATE())).value(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION(), (Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.ADDITIONAL_INFORMATION())).build());
        this.selectStatement = session.prepare(((BuildableQuery)QueryBuilder.selectFrom((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).all().whereColumn(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()).isEqualTo((Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()))).build());
        this.listStatement = session.prepare(QueryBuilder.selectFrom((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).all().build());
        this.removeStatement = session.prepare(((BuildableQuery)QueryBuilder.deleteFrom((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TABLE_NAME()).whereColumn(CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()).isEqualTo((Term)QueryBuilder.bindMarker((String)CassandraTaskExecutionDetailsProjectionTable$.MODULE$.TASK_ID()))).build());
    }
}

