/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class SamplerAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer shardSize;
    public static final JsonpDeserializer<SamplerAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamplerAggregation::setupSamplerAggregationDeserializer);

    private SamplerAggregation(Builder builder) {
        super(builder);
        this.shardSize = builder.shardSize;
    }

    public static SamplerAggregation of(Function<Builder, ObjectBuilder<SamplerAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Sampler;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
    }

    protected static void setupSamplerAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SamplerAggregation> {
        @Nullable
        private Integer shardSize;

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SamplerAggregation build() {
            this._checkSingleUse();
            return new SamplerAggregation(this);
        }
    }
}

