/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.mailbox.model.MailboxAnnotationKey;

public class MailboxAnnotation {
    private final MailboxAnnotationKey key;
    private final Optional<String> value;

    public static MailboxAnnotation nil(MailboxAnnotationKey key) {
        return new MailboxAnnotation(key, Optional.empty());
    }

    public static MailboxAnnotation newInstance(MailboxAnnotationKey key, String value) {
        return new MailboxAnnotation(key, Optional.of(value));
    }

    private MailboxAnnotation(MailboxAnnotationKey key, Optional<String> value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(value);
        this.key = key;
        this.value = value;
    }

    public MailboxAnnotationKey getKey() {
        return this.key;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public int size() {
        if (this.isNil()) {
            return 0;
        }
        return this.value.get().length();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.value});
    }

    public boolean isNil() {
        return !this.value.isPresent();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MailboxAnnotation) {
            MailboxAnnotation o = (MailboxAnnotation)obj;
            return Objects.equal((Object)this.key, (Object)o.getKey()) && Objects.equal(this.value, o.getValue());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key.asString()).add("value", this.value).toString();
    }
}

