/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.webadmin.dto.QuotaDetailsDTO;
import org.apache.james.webadmin.dto.UsersQuotaDetailsDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class UserQuotaService {
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaManager quotaManager;
    private final UserQuotaRootResolver userQuotaRootResolver;
    private final QuotaSearcher quotaSearcher;

    @Inject
    public UserQuotaService(MaxQuotaManager maxQuotaManager, QuotaManager quotaManager, UserQuotaRootResolver userQuotaRootResolver, QuotaSearcher quotaSearcher) {
        this.maxQuotaManager = maxQuotaManager;
        this.quotaManager = quotaManager;
        this.userQuotaRootResolver = userQuotaRootResolver;
        this.quotaSearcher = quotaSearcher;
    }

    public void defineQuota(Username username, ValidatedQuotaDTO quota) {
        QuotaRoot quotaRoot = this.userQuotaRootResolver.forUser(username);
        this.defineUserMaxMessage(quotaRoot, quota).then(this.defineUserMaxStorage(quotaRoot, quota)).block();
    }

    private Mono<Void> defineUserMaxMessage(QuotaRoot quotaRoot, ValidatedQuotaDTO quota) {
        return quota.getCount().map(countLimit -> Mono.from((Publisher)this.maxQuotaManager.setMaxMessageReactive(quotaRoot, countLimit))).orElseGet(() -> Mono.from((Publisher)this.maxQuotaManager.removeMaxMessageReactive(quotaRoot)));
    }

    private Mono<Void> defineUserMaxStorage(QuotaRoot quotaRoot, ValidatedQuotaDTO quota) {
        return quota.getSize().map(sizeLimit -> Mono.from((Publisher)this.maxQuotaManager.setMaxStorageReactive(quotaRoot, sizeLimit))).orElseGet(() -> Mono.from((Publisher)this.maxQuotaManager.removeMaxStorageReactive(quotaRoot)));
    }

    public QuotaDetailsDTO getQuota(Username username) {
        return this.getQuota(this.userQuotaRootResolver.forUser(username));
    }

    private QuotaDetailsDTO getQuota(QuotaRoot quotaRoot) {
        return (QuotaDetailsDTO)Mono.zip((Mono)Mono.from((Publisher)this.quotaManager.getQuotasReactive(quotaRoot)), (Mono)Mono.from((Publisher)this.maxQuotaManager.listMaxMessagesDetailsReactive(quotaRoot)), (Mono)Mono.from((Publisher)this.maxQuotaManager.listMaxStorageDetailsReactive(quotaRoot))).map(tuple3 -> QuotaDetailsDTO.builder().occupation((Quota<QuotaSizeLimit, QuotaSizeUsage>)((QuotaManager.Quotas)tuple3.getT1()).getStorageQuota(), (Quota<QuotaCountLimit, QuotaCountUsage>)((QuotaManager.Quotas)tuple3.getT1()).getMessageQuota()).computed(ValidatedQuotaDTO.builder().count(this.maxQuotaManager.getMaxMessage((Map)tuple3.getT2())).size(this.maxQuotaManager.getMaxStorage((Map)tuple3.getT3())).build()).valueForScopes(this.mergeMaps((Map)tuple3.getT2(), (Map)tuple3.getT3())).build()).block();
    }

    private Map<Quota.Scope, ValidatedQuotaDTO> mergeMaps(Map<Quota.Scope, QuotaCountLimit> counts, Map<Quota.Scope, QuotaSizeLimit> sizes) {
        return Sets.union(counts.keySet(), sizes.keySet()).stream().collect(Collectors.toMap(Function.identity(), scope -> ValidatedQuotaDTO.builder().count(Optional.ofNullable((QuotaCountLimit)counts.get(scope))).size(Optional.ofNullable((QuotaSizeLimit)sizes.get(scope))).build()));
    }

    public Optional<QuotaSizeLimit> getMaxSizeQuota(Username username) {
        return (Optional)Mono.from((Publisher)this.maxQuotaManager.listMaxStorageDetailsReactive(this.userQuotaRootResolver.forUser(username))).map(arg_0 -> ((MaxQuotaManager)this.maxQuotaManager).getMaxStorage(arg_0)).block();
    }

    public void defineMaxSizeQuota(Username username, QuotaSizeLimit quotaSize) {
        Mono.from((Publisher)this.maxQuotaManager.setMaxStorageReactive(this.userQuotaRootResolver.forUser(username), quotaSize)).block();
    }

    public void deleteMaxSizeQuota(Username username) {
        Mono.from((Publisher)this.maxQuotaManager.removeMaxStorageReactive(this.userQuotaRootResolver.forUser(username))).block();
    }

    public Optional<QuotaCountLimit> getMaxCountQuota(Username username) {
        return (Optional)Mono.from((Publisher)this.maxQuotaManager.listMaxMessagesDetailsReactive(this.userQuotaRootResolver.forUser(username))).map(arg_0 -> ((MaxQuotaManager)this.maxQuotaManager).getMaxMessage(arg_0)).block();
    }

    public void defineMaxCountQuota(Username username, QuotaCountLimit quotaCount) {
        Mono.from((Publisher)this.maxQuotaManager.setMaxMessageReactive(this.userQuotaRootResolver.forUser(username), quotaCount)).block();
    }

    public void deleteMaxCountQuota(Username username) {
        Mono.from((Publisher)this.maxQuotaManager.removeMaxMessageReactive(this.userQuotaRootResolver.forUser(username))).block();
    }

    public List<UsersQuotaDetailsDTO> getUsersQuota(QuotaQuery quotaQuery) {
        return (List)this.quotaSearcher.search(quotaQuery).stream().map(Throwing.function(user -> UsersQuotaDetailsDTO.builder().user((Username)user).detail(this.getQuota(this.userQuotaRootResolver.forMailAddress(user))).build())).collect(ImmutableList.toImmutableList());
    }
}

