/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.upload;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.api.upload.UploadUsageRepository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JMAPCurrentUploadUsageCalculator {
    private final UploadRepository uploadRepository;
    private final UploadUsageRepository uploadUsageRepository;

    @Inject
    public JMAPCurrentUploadUsageCalculator(UploadRepository uploadRepository, UploadUsageRepository uploadUsageRepository) {
        this.uploadRepository = uploadRepository;
        this.uploadUsageRepository = uploadUsageRepository;
    }

    public Mono<Void> recomputeCurrentUploadUsage(Username username) {
        return Flux.from(this.uploadRepository.listUploads(username)).map(UploadMetaData::sizeAsLong).reduce(Long::sum).flatMap(sum -> Mono.from(this.uploadUsageRepository.resetSpace(username, QuotaSizeUsage.size((long)sum))));
    }
}

