/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.memory;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;

public class MemoryRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private final Map<MappingSource, Set<Mapping>> table = new HashMap<MappingSource, Set<Mapping>>();

    private Mappings toMappings(Set<Mapping> mappings) {
        return mappings == null ? MappingsImpl.empty() : MappingsImpl.fromMappings(mappings.stream());
    }

    public void addMapping(MappingSource source, Mapping mapping) {
        this.table.computeIfAbsent(source, s -> new LinkedHashSet()).add(mapping);
    }

    public void removeMapping(MappingSource source, Mapping mapping) {
        Set<Mapping> mappings = this.table.get(source);
        if (mappings != null) {
            mappings.remove(mapping);
            if (mappings.isEmpty()) {
                this.table.remove(source);
            }
        }
    }

    public Mappings getStoredMappings(MappingSource mappingSource) {
        return this.toMappings(this.table.get(mappingSource));
    }

    public Map<MappingSource, Mappings> getAllMappings() {
        return this.table.entrySet().stream().collect(Collectors.toMap(e -> (MappingSource)e.getKey(), e -> this.toMappings((Set)e.getValue())));
    }
}

