/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import java.util.function.BooleanSupplier;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Keyword;
import org.jooq.QueryPart;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.ThrowingConsumer;

final class Cast<T>
extends AbstractField<T>
implements QOM.Cast<T> {
    private final Field<?> field;

    Cast(Field<?> field, DataType<T> type) {
        this(field, type, false);
    }

    Cast(Field<?> field, DataType<T> type, boolean retainNullability) {
        super(Names.N_CAST, retainNullability ? type : type.nullable(field.getDataType().nullable()));
        this.field = field;
    }

    private final DataType<T> getSQLDataType() {
        return this.getDataType().getSQLDataType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                ctx.visit(new CastDerby());
                break;
            }
            default: {
                ctx.visit(new CastNative(this.field, this.getDataType()));
            }
        }
    }

    static <E extends Throwable> void renderCast(Context<?> ctx, ThrowingConsumer<? super Context<?>, E> expression, ThrowingConsumer<? super Context<?>, E> type) throws E {
        Cast.renderCast(ctx, expression, type, false);
    }

    static <E extends Throwable> void renderCast(Context<?> ctx, ThrowingConsumer<? super Context<?>, E> expression, ThrowingConsumer<? super Context<?>, E> type, boolean tryCast) throws E {
        RenderContext.CastMode castMode = ctx.castMode();
        if (tryCast) {
            switch (ctx.family()) {
                case CLICKHOUSE: {
                    ctx.visit(Names.N_accurateCastOrNull);
                    break;
                }
                default: {
                    ctx.visit(Names.N_TRY_CAST);
                    break;
                }
            }
        } else {
            ctx.visit(Keywords.K_CAST);
        }
        ctx.sql('(').castMode(RenderContext.CastMode.NEVER);
        expression.accept(ctx);
        ctx.castMode(castMode);
        if (tryCast && ctx.family() == SQLDialect.CLICKHOUSE) {
            ctx.sql(", '").stringLiteral(true);
        } else {
            ctx.sql(' ').visit(Keywords.K_AS).sql(' ');
        }
        type.accept(ctx);
        if (tryCast && ctx.family() == SQLDialect.CLICKHOUSE) {
            ctx.stringLiteral(false).sql('\'');
        }
        ctx.sql(')');
    }

    static <E extends Throwable> void renderCastIf(Context<?> ctx, ThrowingConsumer<? super Context<?>, E> expression, ThrowingConsumer<? super Context<?>, E> type, BooleanSupplier test) throws E {
        if (test.getAsBoolean()) {
            Cast.renderCast(ctx, expression, type);
        } else {
            expression.accept(ctx);
        }
    }

    @Override
    public final Field<?> $field() {
        return this.field;
    }

    private final class CastDerby
    extends CastNative<T> {
        CastDerby() {
            super(Cast.this.field, Cast.this.getDataType());
        }

        private final Field<Boolean> asDecodeNumberToBoolean() {
            return DSL.choose(Cast.this.field).when((Field<?>)DSL.inline(0), DSL.inline(false)).when(DSL.inline((Integer)null), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
        }

        private final Field<Boolean> asDecodeVarcharToBoolean() {
            Field<String> s = Cast.this.field;
            return DSL.when(s.equal(DSL.inline("0")), DSL.inline(false)).when(DSL.lower(s).equal(DSL.inline("false")), (Field<Boolean>)DSL.inline(false)).when(DSL.lower(s).equal(DSL.inline("f")), (Field<Boolean>)DSL.inline(false)).when(s.isNull(), (Field<Boolean>)DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
        }

        @Override
        public final void accept(Context<?> ctx) {
            DataType type = Cast.this.getSQLDataType();
            if (Cast.this.field.getDataType().isNumeric() && type.isString() && !SQLDataType.CHAR.equals(type)) {
                ctx.visit(Keywords.K_TRIM).sql('(').visit(new CastNative(new CastNative<String>(Cast.this.field, SQLDataType.CHAR(38)), Cast.this.getDataType())).sql(')');
            } else if (Cast.this.field.getDataType().isString() && (SQLDataType.FLOAT.equals(type) || SQLDataType.DOUBLE.equals(type) || SQLDataType.REAL.equals(type))) {
                ctx.visit(new CastNative(new CastNative<BigDecimal>(Cast.this.field, SQLDataType.DECIMAL), Cast.this.getDataType()));
            } else if (Cast.this.field.getDataType().isNumeric() && SQLDataType.BOOLEAN.equals(type)) {
                ctx.visit(this.asDecodeNumberToBoolean());
            } else if (Cast.this.field.getDataType().isString() && SQLDataType.BOOLEAN.equals(type)) {
                ctx.visit(this.asDecodeVarcharToBoolean());
            } else {
                super.accept(ctx);
            }
        }
    }

    static class CastNative<T>
    extends AbstractQueryPart
    implements QOM.UTransient {
        final QueryPart expression;
        final DataType<T> type;
        final Keyword typeAsKeyword;
        final boolean tryCast;

        CastNative(QueryPart expression, DataType<T> type) {
            this(expression, type, false);
        }

        CastNative(QueryPart expression, DataType<T> type, boolean tryCast) {
            this.expression = expression;
            this.type = type;
            this.typeAsKeyword = null;
            this.tryCast = tryCast;
        }

        CastNative(QueryPart expression, Keyword typeAsKeyword) {
            this.expression = expression;
            this.type = null;
            this.typeAsKeyword = typeAsKeyword;
            this.tryCast = false;
        }

        @Override
        public void accept(Context<?> ctx) {
            Cast.renderCast(ctx, c -> c.visit(this.expression), c -> {
                if (this.typeAsKeyword != null) {
                    c.visit(this.typeAsKeyword);
                } else {
                    c.sql(this.type.getCastTypeName(c.configuration()));
                }
            }, this.tryCast);
        }
    }
}

