/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.CommonTableExpression;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function3;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.TableLike;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class SplitPart
extends AbstractField<String>
implements QOM.SplitPart {
    final Field<String> string;
    final Field<String> delimiter;
    final Field<? extends Number> n;

    SplitPart(Field<String> string, Field<String> delimiter, Field<? extends Number> n) {
        super(Names.N_SPLIT_PART, Tools.allNotNull(SQLDataType.VARCHAR, string, delimiter, n));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.delimiter = Tools.nullSafeNotNull(delimiter, SQLDataType.VARCHAR);
        this.n = Tools.nullSafeNotNull(n, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: {
                return false;
            }
            case MARIADB: 
            case MYSQL: {
                return false;
            }
            case HSQLDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: {
                ctx.visit(DSL.arrayGet(DSL.function(Names.N_STR_SPLIT, this.getDataType().array(), this.string, this.delimiter), this.n));
                break;
            }
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.substring(DSL.substringIndex(this.string, this.delimiter, this.n), DSL.case_(this.n).when((Field<? extends Number>)DSL.one(), DSL.one()).else_(DSL.length(DSL.substringIndex(this.string, this.delimiter, this.n.minus(DSL.one()))).plus(DSL.length(this.delimiter)).plus(DSL.one()))));
                break;
            }
            case HSQLDB: {
                Field<String> rS = DSL.field(DSL.name("s"), String.class);
                Field<Integer> rN = DSL.field(DSL.name("n"), Integer.TYPE);
                Field<String> rD = DSL.field(DSL.name("d"), String.class);
                Field<Integer> rPos = DSL.position(rS, rD);
                Field<Integer> rLen = DSL.length(rD);
                Field<Integer> rPosN = DSL.nullif(rPos, DSL.zero());
                Field<String> rStr = DSL.substring(rS, rPosN.plus(rLen));
                Field<String> rRes = DSL.coalesce(DSL.substring(rS, DSL.one(), rPosN.minus(DSL.one())), rS);
                CommonTableExpression<Record2<String, String>> s1 = DSL.name("s1").fields("s", "d").as(DSL.select(this.string, this.delimiter));
                CommonTableExpression s2 = DSL.name("s2").fields("s", "d", "x", "n").as(DSL.select(rStr, rD, rRes, DSL.one()).from((TableLike<?>)s1).unionAll((Select)DSL.select(rStr, rD, rRes, rN.plus(DSL.one())).from(DSL.name("s2")).where(rS.isNotNull())));
                Tools.visitSubquery(ctx, DSL.withRecursive(s1, s2).select(DSL.coalesce(DSL.max(DSL.field(DSL.name("x"))), DSL.inline(""))).from((TableLike<?>)s2).where(s2.field("n").eq(this.n)), 1);
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_SPLIT_PART, this.getDataType(), this.string, this.delimiter, this.n));
            }
        }
    }

    @Override
    public final Field<String> $arg1() {
        return this.string;
    }

    @Override
    public final Field<String> $arg2() {
        return this.delimiter;
    }

    @Override
    public final Field<? extends Number> $arg3() {
        return this.n;
    }

    @Override
    public final QOM.SplitPart $arg1(Field<String> newValue) {
        return this.$constructor().apply((Field<String>)newValue, (Field<String>)this.$arg2(), (Field<? extends Number>)this.$arg3());
    }

    @Override
    public final QOM.SplitPart $arg2(Field<String> newValue) {
        return this.$constructor().apply((Field<String>)this.$arg1(), (Field<String>)newValue, (Field<? extends Number>)this.$arg3());
    }

    @Override
    public final QOM.SplitPart $arg3(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<String>)this.$arg1(), (Field<String>)this.$arg2(), (Field<? extends Number>)newValue);
    }

    @Override
    public final Function3<? super Field<String>, ? super Field<String>, ? super Field<? extends Number>, ? extends QOM.SplitPart> $constructor() {
        return (a1, a2, a3) -> new SplitPart((Field<String>)a1, (Field<String>)a2, (Field<? extends Number>)a3);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.SplitPart) {
            QOM.SplitPart o = (QOM.SplitPart)that;
            return StringUtils.equals(this.$string(), o.$string()) && StringUtils.equals(this.$delimiter(), o.$delimiter()) && StringUtils.equals(this.$n(), o.$n());
        }
        return super.equals(that);
    }
}

