/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.util.Assert;

public final class Circle {
    private final Point center;
    private final double radius;

    private Circle(Point center, double radius) {
        this.center = Assert.requireNonNull(center, "center must not be null");
        this.radius = radius;
    }

    public static Circle of(Point center, double radius) {
        return new Circle(center, radius);
    }

    public static Circle of(double x, double y, double radius) {
        return new Circle(Point.of(x, y), radius);
    }

    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Circle) {
            Circle circle = (Circle)obj;
            return circle.center.equals(this.center) && circle.radius == this.radius;
        }
        return false;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ v ^ v >>> 32);
    }

    public String toString() {
        return "<" + this.center.toString() + "," + this.radius + ">";
    }
}

