/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.apache.james.events.CassandraEventDeadLettersDAO;
import org.apache.james.events.CassandraEventDeadLettersGroupDAO;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraEventDeadLetters
implements EventDeadLetters {
    private final CassandraEventDeadLettersDAO cassandraEventDeadLettersDAO;
    private final CassandraEventDeadLettersGroupDAO cassandraEventDeadLettersGroupDAO;

    @Inject
    public CassandraEventDeadLetters(CassandraEventDeadLettersDAO cassandraEventDeadLettersDAO, CassandraEventDeadLettersGroupDAO cassandraEventDeadLettersGroupDAO) {
        this.cassandraEventDeadLettersDAO = cassandraEventDeadLettersDAO;
        this.cassandraEventDeadLettersGroupDAO = cassandraEventDeadLettersGroupDAO;
    }

    public Mono<EventDeadLetters.InsertionId> store(Group registeredGroup, Event failDeliveredEvent) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredEvent != null ? 1 : 0) != 0, (Object)"failDeliveredEvent cannot be null");
        EventDeadLetters.InsertionId insertionId = EventDeadLetters.InsertionId.random();
        return this.cassandraEventDeadLettersDAO.store(registeredGroup, failDeliveredEvent, insertionId).then(this.cassandraEventDeadLettersGroupDAO.storeGroup(registeredGroup)).thenReturn((Object)insertionId);
    }

    public Mono<Void> remove(Group registeredGroup, EventDeadLetters.InsertionId failDeliveredInsertionId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredInsertionId != null ? 1 : 0) != 0, (Object)"failDeliveredInsertionId cannot be null");
        return this.cassandraEventDeadLettersDAO.removeEvent(registeredGroup, failDeliveredInsertionId);
    }

    public Mono<Void> remove(Group registeredGroup) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        return this.cassandraEventDeadLettersDAO.removeEvents(registeredGroup).then(this.cassandraEventDeadLettersGroupDAO.deleteGroup(registeredGroup));
    }

    public Mono<Event> failedEvent(Group registeredGroup, EventDeadLetters.InsertionId failDeliveredInsertionId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredInsertionId != null ? 1 : 0) != 0, (Object)"failDeliveredInsertionId cannot be null");
        return this.cassandraEventDeadLettersDAO.retrieveFailedEvent(registeredGroup, failDeliveredInsertionId);
    }

    public Flux<EventDeadLetters.InsertionId> failedIds(Group registeredGroup) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        return this.cassandraEventDeadLettersDAO.retrieveInsertionIdsWithGroup(registeredGroup);
    }

    public Flux<Group> groupsWithFailedEvents() {
        return this.cassandraEventDeadLettersGroupDAO.retrieveAllGroups();
    }

    public Mono<Boolean> containEvents() {
        return this.cassandraEventDeadLettersDAO.containEvents();
    }
}

