/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.GeoDistanceType;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.opensearch._types.query_dsl.GeoValidationMethod;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class GeoDistanceQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final GeoLocation location;
    @Nullable
    private final String distance;
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final GeoValidationMethod validationMethod;
    @Nullable
    private final Boolean ignoreUnmapped;
    public static final JsonpDeserializer<GeoDistanceQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceQuery::setupGeoDistanceQueryDeserializer);

    private GeoDistanceQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.location = ApiTypeHelper.requireNonNull(builder.location, this, "location");
        this.distance = builder.distance;
        this.distanceType = builder.distanceType;
        this.validationMethod = builder.validationMethod;
        this.ignoreUnmapped = builder.ignoreUnmapped;
    }

    public static GeoDistanceQuery of(Function<Builder, ObjectBuilder<GeoDistanceQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.GeoDistance;
    }

    public final String field() {
        return this.field;
    }

    public final GeoLocation location() {
        return this.location;
    }

    @Nullable
    public final String distance() {
        return this.distance;
    }

    @Nullable
    public final GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public final GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.location.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
        if (this.distance != null) {
            generator.writeKey("distance");
            generator.write(this.distance);
        }
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).field(this.field).location(this.location).distance(this.distance).distanceType(this.distanceType).validationMethod(this.validationMethod).ignoreUnmapped(this.ignoreUnmapped);
    }

    protected static void setupGeoDistanceQueryDeserializer(ObjectDeserializer<Builder> op) {
        GeoDistanceQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::distance, JsonpDeserializer.stringDeserializer(), "distance");
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type");
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method");
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.location(GeoLocation._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoDistanceQuery> {
        private String field;
        private GeoLocation location;
        @Nullable
        private String distance;
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private GeoValidationMethod validationMethod;
        @Nullable
        private Boolean ignoreUnmapped;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder location(GeoLocation value) {
            this.location = value;
            return this;
        }

        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        public final Builder distance(@Nullable String value) {
            this.distance = value;
            return this;
        }

        public final Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        public final Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoDistanceQuery build() {
            this._checkSingleUse();
            return new GeoDistanceQuery(this);
        }
    }
}

