/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.UrlJwkProvider;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.security.PublicKey;
import java.util.List;
import java.util.Optional;
import org.apache.james.jwt.MissingOrInvalidKeyException;
import org.apache.james.jwt.PublicKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwksPublicKeyProvider
implements PublicKeyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwksPublicKeyProvider.class);
    private final UrlJwkProvider jwkProvider;

    public static JwksPublicKeyProvider of(URL jwksURL) {
        return new JwksPublicKeyProvider(jwksURL);
    }

    private JwksPublicKeyProvider(URL jwksURL) {
        Preconditions.checkNotNull((Object)jwksURL);
        this.jwkProvider = new UrlJwkProvider(jwksURL);
    }

    @Override
    public List<PublicKey> get() throws MissingOrInvalidKeyException {
        return this.getAllFromProvider();
    }

    @Override
    public Optional<PublicKey> get(String kid) throws MissingOrInvalidKeyException {
        try {
            return Optional.of(this.jwkProvider.get(kid).getPublicKey());
        }
        catch (SigningKeyNotFoundException notFoundException) {
            return Optional.empty();
        }
        catch (JwkException e) {
            LOGGER.error("Can't get publicKeys has kid = {} from jwksURL.", (Object)kid, (Object)e);
            throw new MissingOrInvalidKeyException();
        }
    }

    private List<PublicKey> getAllFromProvider() throws MissingOrInvalidKeyException {
        try {
            return (List)this.jwkProvider.getAll().stream().map(Throwing.function(Jwk::getPublicKey)).collect(ImmutableList.toImmutableList());
        }
        catch (JwkException e) {
            LOGGER.error("Can't get publicKeys from jwksURL.", (Throwable)e);
            throw new MissingOrInvalidKeyException();
        }
    }
}

