/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplicaMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String REPLICA_MONITOR_OC = "ds-replica-monitor-entry";
    @NotNull
    private static final String ATTR_AGE_OF_OLDEST_PENDING_UPDATE_MILLIS = "age-of-oldest-pending-update";
    @NotNull
    private static final String ATTR_BASE_DN = "base-dn";
    @NotNull
    private static final String ATTR_CONFLICT_ENTRY_COUNT = "conflict-entry-count";
    @NotNull
    private static final String ATTR_CONNECTED_TO = "connected-to";
    @NotNull
    private static final String ATTR_CURRENT_RECEIVE_WINDOW_SIZE = "current-rcv-window";
    @NotNull
    private static final String ATTR_CURRENT_SEND_WINDOW_SIZE = "current-send-window";
    @NotNull
    private static final String ATTR_FAILED_REPLAYED = "replayed-updates-failed";
    @NotNull
    private static final String ATTR_GENERATION_ID = "generation-id";
    @NotNull
    private static final String ATTR_LAST_UPDATE_LATENCY_MILLIS = "last-update-latency-millis";
    @NotNull
    private static final String ATTR_LOST_CONNECTIONS = "lost-connections";
    @NotNull
    private static final String ATTR_MAX_RECEIVE_WINDOW_SIZE = "max-rcv-window";
    @NotNull
    private static final String ATTR_MAX_SEND_WINDOW_SIZE = "max-send-window";
    @NotNull
    private static final String ATTR_OLDEST_BACKLOG_CHANGE_TIME = "age-of-oldest-backlog-change";
    @NotNull
    private static final String ATTR_PENDING_CHANGES_CURRENT_UNCOMMITTED_SIZE = "pending-changes-current-uncommitted-size";
    @NotNull
    private static final String ATTR_PENDING_CHANGES_LARGEST_SIZE_REACHED = "pending-changes-largest-size-reached";
    @NotNull
    private static final String ATTR_PENDING_CHANGES_MAX_CAPACITY = "pending-changes-max-capacity";
    @NotNull
    private static final String ATTR_PENDING_CHANGES_NUM_TIMES_ADDED_TO_FULL_QUEUE = "pending-changes-num-times-added-to-full-queue";
    @NotNull
    private static final String ATTR_PENDING_CHANGES_NUM_TIMES_STALL_LOGGED = "pending-changes-num-times-stall-logged";
    @NotNull
    private static final String ATTR_PENDING_UPDATES = "pending-updates";
    @NotNull
    private static final String ATTR_RECEIVED_ACKS = "received-acks";
    @NotNull
    private static final String ATTR_RECEIVED_UPDATES = "received-updates";
    @NotNull
    private static final String ATTR_RECENT_AVERAGE_LATENCY_MILLIS = "recent-average-latency-millis";
    @NotNull
    private static final String ATTR_RECENT_MAXIMUM_LATENCY_MILLIS = "recent-maximum-latency-millis";
    @NotNull
    private static final String ATTR_RECENT_MINIMUM_LATENCY_MILLIS = "recent-minimum-latency-millis";
    @NotNull
    private static final String ATTR_RECENT_NEGATIVE_LATENCY_UPDATE_COUNT = "recent-negative-latency-update-count";
    @NotNull
    private static final String ATTR_RECENT_SUM_LATENCY_MILLIS = "recent-sum-latency-millis";
    @NotNull
    private static final String ATTR_RECENT_UPDATE_COUNT = "recent-update-count";
    @NotNull
    private static final String ATTR_REPLICA_ID = "replica-id";
    @NotNull
    private static final String ATTR_REPLICATION_ASSURANCE_COMPLETED_ABNORMALLY = "replication-assurance-completed-abnormally";
    @NotNull
    private static final String ATTR_REPLICATION_ASSURANCE_COMPLETED_NORMALLY = "replication-assurance-completed-normally";
    @NotNull
    private static final String ATTR_REPLICATION_ASSURANCE_COMPLETED_WITH_SHUTDOWN = "replication-assurance-completed-with-shutdown";
    @NotNull
    private static final String ATTR_REPLICATION_ASSURANCE_COMPLETED_WITH_TIMEOUT = "replication-assurance-completed-with-timeout";
    @NotNull
    private static final String ATTR_REPLICATION_ASSURANCE_SUBMITTED_OPERATIONS = "replication-assurance-submitted-operations";
    @NotNull
    private static final String ATTR_REPLICATION_BACKLOG = "replication-backlog";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_ADD_FAILED_COUNT = "requeue-retry-add-failed-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_ADD_SUCCESS_COUNT = "requeue-retry-add-success-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_DELETE_FAILED_COUNT = "requeue-retry-delete-failed-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_DELETE_SUCCESS_COUNT = "requeue-retry-delete-success-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_MODIFY_DN_FAILED_COUNT = "requeue-retry-modify-dn-failed-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_MODIFY_DN_SUCCESS_COUNT = "requeue-retry-modify-dn-success-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_MODIFY_FAILED_COUNT = "requeue-retry-modify-failed-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_MODIFY_SUCCESS_COUNT = "requeue-retry-modify-success-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_OP_FAILED_COUNT = "requeue-retry-op-failed-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_OP_SUCCESS_COUNT = "requeue-retry-op-success-count";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_OP_SUCCESS_AVERAGE_DURATION_MILLIS = "requeue-retry-op-success-average-duration-millis";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_OP_SUCCESS_MAXIMUM_DURATION_MILLIS = "requeue-retry-op-success-maximum-duration-millis";
    @NotNull
    private static final String ATTR_REQUEUE_RETRY_OP_SUCCESS_TOTAL_DURATION_MILLIS = "requeue-retry-op-success-total-millis";
    @NotNull
    private static final String ATTR_RESOLVED_MODIFY_CONFLICTS = "resolved-modify-conflicts";
    @NotNull
    private static final String ATTR_RESOLVED_NAMING_CONFLICTS = "resolved-naming-conflicts";
    @NotNull
    private static final String ATTR_SENT_ACKS = "sent-acks";
    @NotNull
    private static final String ATTR_SENT_UPDATES = "sent-updates";
    @NotNull
    private static final String ATTR_SSL_ENCRYPTION = "ssl-encryption";
    @NotNull
    private static final String ATTR_SUCCESSFUL_REPLAYED = "replayed-updates-ok";
    @NotNull
    private static final String ATTR_TOTAL_AVERAGE_LATENCY_MILLIS = "total-average-latency-millis";
    @NotNull
    private static final String ATTR_TOTAL_MAXIMUM_LATENCY_MILLIS = "total-maximum-latency-millis";
    @NotNull
    private static final String ATTR_TOTAL_MINIMUM_LATENCY_MILLIS = "total-minimum-latency-millis";
    @NotNull
    private static final String ATTR_TOTAL_NEGATIVE_LATENCY_UPDATE_COUNT = "total-negative-latency-update-count";
    @NotNull
    private static final String ATTR_TOTAL_REPLAYED = "replayed-updates";
    @NotNull
    private static final String ATTR_TOTAL_SUM_LATENCY_MILLIS = "total-sum-latency-millis";
    @NotNull
    private static final String ATTR_TOTAL_UPDATE_COUNT = "total-update-count";
    @NotNull
    private static final String ATTR_UNRESOLVED_NAMING_CONFLICTS = "unresolved-naming-conflicts";
    private static final long serialVersionUID = -2327746532075017532L;
    @Nullable
    private final Boolean useSSL = this.getBoolean("ssl-encryption");
    @Nullable
    private final Date oldestBacklogChangeTime = this.getDate("age-of-oldest-backlog-change");
    @Nullable
    private final Double requeueRetrySuccessAverageDurationMillis = this.getDouble("requeue-retry-op-success-average-duration-millis");
    @Nullable
    private final Double requeueRetrySuccessMaximumDurationMillis = this.getDouble("requeue-retry-op-success-maximum-duration-millis");
    @Nullable
    private final Long ageOfOldestPendingUpdateMillis = this.getLong("age-of-oldest-pending-update");
    @Nullable
    private final Long conflictEntryCount = this.getLong("conflict-entry-count");
    @Nullable
    private final Long currentReceiveWindowSize = this.getLong("current-rcv-window");
    @Nullable
    private final Long currentSendWindowSize = this.getLong("current-send-window");
    @Nullable
    private final Long failedReplayed = this.getLong("replayed-updates-failed");
    @Nullable
    private final Long lastUpdateLatencyMillis = this.getLong("last-update-latency-millis");
    @Nullable
    private final Long lostConnections = this.getLong("lost-connections");
    @Nullable
    private final Long maxReceiveWindowSize = this.getLong("max-rcv-window");
    @Nullable
    private final Long maxSendWindowSize = this.getLong("max-send-window");
    @Nullable
    private final Long pendingChangesCurrentUncommittedSize = this.getLong("pending-changes-current-uncommitted-size");
    @Nullable
    private final Long pendingChangesLargestSizeReached = this.getLong("pending-changes-largest-size-reached");
    @Nullable
    private final Long pendingChangesMaxCapacity = this.getLong("pending-changes-max-capacity");
    @Nullable
    private final Long pendingChangesNumTimesAddedToFullQueue = this.getLong("pending-changes-num-times-added-to-full-queue");
    @Nullable
    private final Long pendingChangesNumTimesStallLogged = this.getLong("pending-changes-num-times-stall-logged");
    @Nullable
    private final Long pendingUpdates = this.getLong("pending-updates");
    @Nullable
    private final Long receivedAcks = this.getLong("received-acks");
    @Nullable
    private final Long receivedUpdates = this.getLong("received-updates");
    @Nullable
    private final Long recentAverageLatencyMillis = this.getLong("recent-average-latency-millis");
    @Nullable
    private final Long recentMaximumLatencyMillis = this.getLong("recent-maximum-latency-millis");
    @Nullable
    private final Long recentMinimumLatencyMillis = this.getLong("recent-minimum-latency-millis");
    @Nullable
    private final Long recentNegativeLatencyUpdateCount = this.getLong("recent-negative-latency-update-count");
    @Nullable
    private final Long recentSumLatencyMillis = this.getLong("recent-sum-latency-millis");
    @Nullable
    private final Long recentUpdateCount = this.getLong("recent-update-count");
    @Nullable
    private final Long replayedAfterModifyConflict = this.getLong("resolved-modify-conflicts");
    @Nullable
    private final Long replayedAfterNamingConflict = this.getLong("resolved-naming-conflicts");
    @Nullable
    private final Long replicationAssuranceCompletedAbnormally = this.getLong("replication-assurance-completed-abnormally");
    @Nullable
    private final Long replicationAssuranceCompletedNormally = this.getLong("replication-assurance-completed-normally");
    @Nullable
    private final Long replicationAssuranceCompletedWithShutdown = this.getLong("replication-assurance-completed-with-shutdown");
    @Nullable
    private final Long replicationAssuranceCompletedWithTimeout = this.getLong("replication-assurance-completed-with-timeout");
    @Nullable
    private final Long replicationAssuranceSubmittedOperations = this.getLong("replication-assurance-submitted-operations");
    @Nullable
    private final Long replicationBacklog = this.getLong("replication-backlog");
    @Nullable
    private final Long replicationServerPort;
    @Nullable
    private final Long requeueRetryAddFailedCount = this.getLong("requeue-retry-add-failed-count");
    @Nullable
    private final Long requeueRetryAddSuccessCount = this.getLong("requeue-retry-add-success-count");
    @Nullable
    private final Long requeueRetryDeleteFailedCount = this.getLong("requeue-retry-delete-failed-count");
    @Nullable
    private final Long requeueRetryDeleteSuccessCount = this.getLong("requeue-retry-delete-success-count");
    @Nullable
    private final Long requeueRetryModifyDNFailedCount;
    @Nullable
    private final Long requeueRetryModifyDNSuccessCount;
    @Nullable
    private final Long requeueRetryModifyFailedCount = this.getLong("requeue-retry-modify-failed-count");
    @Nullable
    private final Long requeueRetryModifySuccessCount = this.getLong("requeue-retry-modify-success-count");
    @Nullable
    private final Long requeueRetryOpFailedCount;
    @Nullable
    private final Long requeueRetryOpSuccessCount;
    @Nullable
    private final Long requeueRetrySuccessTotalDurationMillis;
    @Nullable
    private final Long sentAcks;
    @Nullable
    private final Long sentUpdates;
    @Nullable
    private final Long successfullyReplayed;
    @Nullable
    private final Long totalAverageLatencyMillis;
    @Nullable
    private final Long totalMaximumLatencyMillis;
    @Nullable
    private final Long totalMinimumLatencyMillis;
    @Nullable
    private final Long totalNegativeLatencyUpdateCount;
    @Nullable
    private final Long totalReplayed;
    @Nullable
    private final Long totalSumLatencyMillis;
    @Nullable
    private final Long totalUpdateCount;
    @Nullable
    private final Long unresolvedNamingConflicts;
    @Nullable
    private final String baseDN;
    @Nullable
    private final String generationID;
    @Nullable
    private final String replicaID;
    @Nullable
    private final String replicationServerAddress;

    public ReplicaMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.requeueRetryModifyDNFailedCount = this.getLong(ATTR_REQUEUE_RETRY_MODIFY_DN_FAILED_COUNT);
        this.requeueRetryModifyDNSuccessCount = this.getLong(ATTR_REQUEUE_RETRY_MODIFY_DN_SUCCESS_COUNT);
        this.requeueRetryOpFailedCount = this.getLong(ATTR_REQUEUE_RETRY_OP_FAILED_COUNT);
        this.requeueRetryOpSuccessCount = this.getLong(ATTR_REQUEUE_RETRY_OP_SUCCESS_COUNT);
        this.requeueRetrySuccessTotalDurationMillis = this.getLong(ATTR_REQUEUE_RETRY_OP_SUCCESS_TOTAL_DURATION_MILLIS);
        this.sentAcks = this.getLong(ATTR_SENT_ACKS);
        this.sentUpdates = this.getLong(ATTR_SENT_UPDATES);
        this.successfullyReplayed = this.getLong(ATTR_SUCCESSFUL_REPLAYED);
        this.totalAverageLatencyMillis = this.getLong(ATTR_TOTAL_AVERAGE_LATENCY_MILLIS);
        this.totalMaximumLatencyMillis = this.getLong(ATTR_TOTAL_MAXIMUM_LATENCY_MILLIS);
        this.totalMinimumLatencyMillis = this.getLong(ATTR_TOTAL_MINIMUM_LATENCY_MILLIS);
        this.totalNegativeLatencyUpdateCount = this.getLong(ATTR_TOTAL_NEGATIVE_LATENCY_UPDATE_COUNT);
        this.totalReplayed = this.getLong(ATTR_TOTAL_REPLAYED);
        this.totalSumLatencyMillis = this.getLong(ATTR_TOTAL_SUM_LATENCY_MILLIS);
        this.totalUpdateCount = this.getLong(ATTR_TOTAL_UPDATE_COUNT);
        this.unresolvedNamingConflicts = this.getLong(ATTR_UNRESOLVED_NAMING_CONFLICTS);
        this.baseDN = this.getString(ATTR_BASE_DN);
        this.generationID = this.getString(ATTR_GENERATION_ID);
        this.replicaID = this.getString(ATTR_REPLICA_ID);
        String addr = null;
        Long port = null;
        String connectedTo = this.getString(ATTR_CONNECTED_TO);
        if (connectedTo != null) {
            try {
                int colonPos = connectedTo.indexOf(58);
                if (colonPos > 0) {
                    addr = connectedTo.substring(0, colonPos);
                    port = Long.parseLong(connectedTo.substring(colonPos + 1));
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                addr = null;
                port = null;
            }
        }
        this.replicationServerAddress = addr;
        this.replicationServerPort = port;
    }

    @Nullable
    public String getBaseDN() {
        return this.baseDN;
    }

    @Nullable
    public String getReplicaID() {
        return this.replicaID;
    }

    @Nullable
    public String getGenerationID() {
        return this.generationID;
    }

    @Nullable
    public String getReplicationServerAddress() {
        return this.replicationServerAddress;
    }

    @Nullable
    public Long getReplicationServerPort() {
        return this.replicationServerPort;
    }

    @Nullable
    public Boolean useSSL() {
        return this.useSSL;
    }

    @Nullable
    public Long getLostConnections() {
        return this.lostConnections;
    }

    @Nullable
    public Long getTotalUpdateCount() {
        return this.totalUpdateCount;
    }

    @Nullable
    public Long getReceivedUpdates() {
        return this.receivedUpdates;
    }

    @Nullable
    public Long getSentUpdates() {
        return this.sentUpdates;
    }

    @Nullable
    public Long getReceivedAcks() {
        return this.receivedAcks;
    }

    @Nullable
    public Long getSentAcks() {
        return this.sentAcks;
    }

    @Nullable
    public Long getPendingUpdates() {
        return this.pendingUpdates;
    }

    @Nullable
    public Long getTotalUpdatesReplayed() {
        return this.totalReplayed;
    }

    @Nullable
    public Long getUpdatesSuccessfullyReplayed() {
        return this.successfullyReplayed;
    }

    @Nullable
    public Long getUpdateReplayFailures() {
        return this.failedReplayed;
    }

    @Nullable
    public Long getUpdatesReplayedAfterModifyConflict() {
        return this.replayedAfterModifyConflict;
    }

    @Nullable
    public Long getUpdatesReplayedAfterNamingConflict() {
        return this.replayedAfterNamingConflict;
    }

    @Nullable
    public Long getUnresolvedNamingConflicts() {
        return this.unresolvedNamingConflicts;
    }

    @Nullable
    public Long getConflictEntryCount() {
        return this.conflictEntryCount;
    }

    @Nullable
    public Long getCurrentReceiveWindowSize() {
        return this.currentReceiveWindowSize;
    }

    @Nullable
    public Long getCurrentSendWindowSize() {
        return this.currentSendWindowSize;
    }

    @Nullable
    public Long getMaximumReceiveWindowSize() {
        return this.maxReceiveWindowSize;
    }

    @Nullable
    public Long getMaximumSendWindowSize() {
        return this.maxSendWindowSize;
    }

    @Nullable
    public Long getReplicationBacklog() {
        return this.replicationBacklog;
    }

    @Nullable
    public Date getOldestBacklogChangeTime() {
        return this.oldestBacklogChangeTime;
    }

    @Nullable
    public Long getPendingChangesCurrentUncommittedSize() {
        return this.pendingChangesCurrentUncommittedSize;
    }

    @Nullable
    public Long getAgeOfOldestPendingUpdateMillis() {
        return this.ageOfOldestPendingUpdateMillis;
    }

    @Nullable
    public Long getPendingChangesMaxCapacity() {
        return this.pendingChangesMaxCapacity;
    }

    @Nullable
    public Long getPendingChangesLargestSizeReached() {
        return this.pendingChangesLargestSizeReached;
    }

    @Nullable
    public Long getPendingChangesNumTimesAddedToFullQueue() {
        return this.pendingChangesNumTimesAddedToFullQueue;
    }

    @Nullable
    public Long getPendingChangesNumTimesStallLogged() {
        return this.pendingChangesNumTimesStallLogged;
    }

    @Nullable
    public Long getLastUpdateLatencyMillis() {
        return this.lastUpdateLatencyMillis;
    }

    @Nullable
    public Long getRecentAverageLatencyMillis() {
        return this.recentAverageLatencyMillis;
    }

    @Nullable
    public Long getRecentMaximumLatencyMillis() {
        return this.recentMaximumLatencyMillis;
    }

    @Nullable
    public Long getRecentMinimumLatencyMillis() {
        return this.recentMinimumLatencyMillis;
    }

    @Nullable
    public Long getRecentNegativeLatencyUpdateCount() {
        return this.recentNegativeLatencyUpdateCount;
    }

    @Nullable
    public Long getRecentSumLatencyMillis() {
        return this.recentSumLatencyMillis;
    }

    @Nullable
    public Long getRecentUpdateCount() {
        return this.recentUpdateCount;
    }

    @Nullable
    public Long getTotalAverageLatencyMillis() {
        return this.totalAverageLatencyMillis;
    }

    @Nullable
    public Long getTotalMaximumLatencyMillis() {
        return this.totalMaximumLatencyMillis;
    }

    @Nullable
    public Long getTotalMinimumLatencyMillis() {
        return this.totalMinimumLatencyMillis;
    }

    @Nullable
    public Long getTotalNegativeLatencyUpdateCount() {
        return this.totalNegativeLatencyUpdateCount;
    }

    @Nullable
    public Long getTotalSumLatencyMillis() {
        return this.totalSumLatencyMillis;
    }

    @Nullable
    public Long getReplicationAssuranceSubmittedOperations() {
        return this.replicationAssuranceSubmittedOperations;
    }

    @Nullable
    public Long getReplicationAssuranceCompletedNormally() {
        return this.replicationAssuranceCompletedNormally;
    }

    @Nullable
    public Long getReplicationAssuranceCompletedAbnormally() {
        return this.replicationAssuranceCompletedAbnormally;
    }

    @Nullable
    public Long getReplicationAssuranceCompletedWithTimeout() {
        return this.replicationAssuranceCompletedWithTimeout;
    }

    @Nullable
    public Long getReplicationAssuranceCompletedWithShutdown() {
        return this.replicationAssuranceCompletedWithShutdown;
    }

    @Nullable
    public Long getRequeueRetryOpSuccessCount() {
        return this.requeueRetryOpSuccessCount;
    }

    @Nullable
    public Long getRequeueRetryOpFailedCount() {
        return this.requeueRetryOpFailedCount;
    }

    @Nullable
    public Long getRequeueRetryAddSuccessCount() {
        return this.requeueRetryAddSuccessCount;
    }

    @Nullable
    public Long getRequeueRetryAddFailedCount() {
        return this.requeueRetryAddFailedCount;
    }

    @Nullable
    public Long getRequeueRetryDeleteSuccessCount() {
        return this.requeueRetryDeleteSuccessCount;
    }

    @Nullable
    public Long getRequeueRetryDeleteFailedCount() {
        return this.requeueRetryDeleteFailedCount;
    }

    @Nullable
    public Long getRequeueRetryModifySuccessCount() {
        return this.requeueRetryModifySuccessCount;
    }

    @Nullable
    public Long getRequeueRetryModifyFailedCount() {
        return this.requeueRetryModifyFailedCount;
    }

    @Nullable
    public Long getRequeueRetryModifyDNSuccessCount() {
        return this.requeueRetryModifyDNSuccessCount;
    }

    @Nullable
    public Long getRequeueRetryModifyDNFailedCount() {
        return this.requeueRetryModifyDNFailedCount;
    }

    @Nullable
    public Double getRequeueRetrySuccessAverageDurationMillis() {
        return this.requeueRetrySuccessAverageDurationMillis;
    }

    @Nullable
    public Double getRequeueRetrySuccessMaximumDurationMillis() {
        return this.requeueRetrySuccessMaximumDurationMillis;
    }

    @Nullable
    public Long getRequeueRetrySuccessTotalDurationMillis() {
        return this.requeueRetrySuccessTotalDurationMillis;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_REPLICA_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_REPLICA_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(30));
        if (this.baseDN != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_BASE_DN, MonitorMessages.INFO_REPLICA_DISPNAME_BASE_DN.get(), MonitorMessages.INFO_REPLICA_DESC_BASE_DN.get(), this.baseDN);
        }
        if (this.replicaID != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICA_ID, MonitorMessages.INFO_REPLICA_DISPNAME_REPLICA_ID.get(), MonitorMessages.INFO_REPLICA_DESC_REPLICA_ID.get(), this.replicaID);
        }
        if (this.generationID != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_GENERATION_ID, MonitorMessages.INFO_REPLICA_DISPNAME_GENERATION_ID.get(), MonitorMessages.INFO_REPLICA_DESC_GENERATION_ID.get(), this.generationID);
        }
        if (this.replicationServerAddress != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_CONNECTED_TO, MonitorMessages.INFO_REPLICA_DISPNAME_CONNECTED_TO.get(), MonitorMessages.INFO_REPLICA_DESC_CONNECTED_TO.get(), this.replicationServerAddress + ':' + this.replicationServerPort);
        }
        if (this.useSSL != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_SSL_ENCRYPTION, MonitorMessages.INFO_REPLICA_DISPNAME_USE_SSL.get(), MonitorMessages.INFO_REPLICA_DESC_USE_SSL.get(), this.useSSL);
        }
        if (this.lostConnections != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_LOST_CONNECTIONS, MonitorMessages.INFO_REPLICA_DISPNAME_LOST_CONNECTIONS.get(), MonitorMessages.INFO_REPLICA_DESC_LOST_CONNECTIONS.get(), this.lostConnections);
        }
        if (this.totalUpdateCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_UPDATE_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_TOTAL_UPDATE_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_TOTAL_UPDATE_COUNT.get(), this.totalUpdateCount);
        }
        if (this.receivedUpdates != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RECEIVED_UPDATES, MonitorMessages.INFO_REPLICA_DISPNAME_RECEIVED_UPDATES.get(), MonitorMessages.INFO_REPLICA_DESC_RECEIVED_UPDATES.get(), this.receivedUpdates);
        }
        if (this.sentUpdates != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_SENT_UPDATES, MonitorMessages.INFO_REPLICA_DISPNAME_SENT_UPDATES.get(), MonitorMessages.INFO_REPLICA_DESC_SENT_UPDATES.get(), this.sentUpdates);
        }
        if (this.receivedAcks != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RECEIVED_ACKS, MonitorMessages.INFO_REPLICA_DISPNAME_RECEIVED_ACKS.get(), MonitorMessages.INFO_REPLICA_DESC_RECEIVED_ACKS.get(), this.receivedAcks);
        }
        if (this.sentAcks != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_SENT_ACKS, MonitorMessages.INFO_REPLICA_DISPNAME_SENT_ACKS.get(), MonitorMessages.INFO_REPLICA_DESC_SENT_ACKS.get(), this.sentAcks);
        }
        if (this.pendingUpdates != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_PENDING_UPDATES, MonitorMessages.INFO_REPLICA_DISPNAME_PENDING_UPDATES.get(), MonitorMessages.INFO_REPLICA_DESC_PENDING_UPDATES.get(), this.pendingUpdates);
        }
        if (this.totalReplayed != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_REPLAYED, MonitorMessages.INFO_REPLICA_DISPNAME_TOTAL_REPLAYED.get(), MonitorMessages.INFO_REPLICA_DESC_TOTAL_REPLAYED.get(), this.totalReplayed);
        }
        if (this.successfullyReplayed != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_SUCCESSFUL_REPLAYED, MonitorMessages.INFO_REPLICA_DISPNAME_SUCCESSFUL_REPLAYED.get(), MonitorMessages.INFO_REPLICA_DESC_SUCCESSFUL_REPLAYED.get(), this.successfullyReplayed);
        }
        if (this.failedReplayed != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_FAILED_REPLAYED, MonitorMessages.INFO_REPLICA_DISPNAME_FAILED_REPLAYED.get(), MonitorMessages.INFO_REPLICA_DESC_FAILED_REPLAYED.get(), this.failedReplayed);
        }
        if (this.replayedAfterModifyConflict != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RESOLVED_MODIFY_CONFLICTS, MonitorMessages.INFO_REPLICA_DISPNAME_RESOLVED_MODIFY_CONFLICTS.get(), MonitorMessages.INFO_REPLICA_DESC_RESOLVED_MODIFY_CONFLICTS.get(), this.replayedAfterModifyConflict);
        }
        if (this.replayedAfterNamingConflict != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RESOLVED_NAMING_CONFLICTS, MonitorMessages.INFO_REPLICA_DISPNAME_RESOLVED_NAMING_CONFLICTS.get(), MonitorMessages.INFO_REPLICA_DESC_RESOLVED_NAMING_CONFLICTS.get(), this.replayedAfterNamingConflict);
        }
        if (this.unresolvedNamingConflicts != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_UNRESOLVED_NAMING_CONFLICTS, MonitorMessages.INFO_REPLICA_DISPNAME_UNRESOLVED_NAMING_CONFLICTS.get(), MonitorMessages.INFO_REPLICA_DESC_UNRESOLVED_NAMING_CONFLICTS.get(), this.unresolvedNamingConflicts);
        }
        if (this.conflictEntryCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_CONFLICT_ENTRY_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_CONFLICT_ENTRY_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_CONFLICT_ENTRY_COUNT.get(), this.conflictEntryCount);
        }
        if (this.currentReceiveWindowSize != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_RECEIVE_WINDOW_SIZE, MonitorMessages.INFO_REPLICA_DISPNAME_CURRENT_RECEIVE_WINDOW_SIZE.get(), MonitorMessages.INFO_REPLICA_DESC_CURRENT_RECEIVE_WINDOW_SIZE.get(), this.currentReceiveWindowSize);
        }
        if (this.currentSendWindowSize != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_SEND_WINDOW_SIZE, MonitorMessages.INFO_REPLICA_DISPNAME_CURRENT_SEND_WINDOW_SIZE.get(), MonitorMessages.INFO_REPLICA_DESC_CURRENT_SEND_WINDOW_SIZE.get(), this.currentSendWindowSize);
        }
        if (this.maxReceiveWindowSize != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_RECEIVE_WINDOW_SIZE, MonitorMessages.INFO_REPLICA_DISPNAME_MAX_RECEIVE_WINDOW_SIZE.get(), MonitorMessages.INFO_REPLICA_DESC_MAX_RECEIVE_WINDOW_SIZE.get(), this.maxReceiveWindowSize);
        }
        if (this.maxSendWindowSize != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_SEND_WINDOW_SIZE, MonitorMessages.INFO_REPLICA_DISPNAME_MAX_SEND_WINDOW_SIZE.get(), MonitorMessages.INFO_REPLICA_DESC_MAX_SEND_WINDOW_SIZE.get(), this.maxSendWindowSize);
        }
        if (this.replicationBacklog != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_BACKLOG, MonitorMessages.INFO_REPLICA_DISPNAME_REPLICATION_BACKLOG.get(), MonitorMessages.INFO_REPLICA_DESC_REPLICATION_BACKLOG.get(), this.replicationBacklog);
        }
        if (this.oldestBacklogChangeTime != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_OLDEST_BACKLOG_CHANGE_TIME, MonitorMessages.INFO_REPLICA_DISPNAME_OLDEST_BACKLOG_CHANGE_TIME.get(), MonitorMessages.INFO_REPLICA_DESC_OLDEST_BACKLOG_CHANGE_TIME.get(), this.oldestBacklogChangeTime);
        }
        if (this.pendingChangesCurrentUncommittedSize != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_PENDING_CHANGES_CURRENT_UNCOMMITTED_SIZE, MonitorMessages.INFO_REPLICA_DISPNAME_PENDING_CHANGES_UNCOMMITTED_SIZE.get(), MonitorMessages.INFO_REPLICA_DESC_PENDING_CHANGES_UNCOMMITTED_SIZE.get(), this.pendingChangesCurrentUncommittedSize);
        }
        if (this.ageOfOldestPendingUpdateMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_AGE_OF_OLDEST_PENDING_UPDATE_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_AGE_OF_OLDEST_PENDING_UPDATE.get(), MonitorMessages.INFO_REPLICA_DESC_AGE_OF_OLDEST_PENDING_UPDATE.get(), this.ageOfOldestPendingUpdateMillis);
        }
        if (this.pendingChangesMaxCapacity != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_PENDING_CHANGES_MAX_CAPACITY, MonitorMessages.INFO_REPLICA_DISPNAME_PENDING_CHANGES_MAX_CAPACITY.get(), MonitorMessages.INFO_REPLICA_DESC_PENDING_CHANGES_MAX_CAPACITY.get(), this.pendingChangesMaxCapacity);
        }
        if (this.pendingChangesLargestSizeReached != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_PENDING_CHANGES_LARGEST_SIZE_REACHED, MonitorMessages.INFO_REPLICA_DISPNAME_PENDING_CHANGES_LARGEST_SIZE.get(), MonitorMessages.INFO_REPLICA_DESC_PENDING_CHANGES_LARGEST_SIZE.get(), this.pendingChangesLargestSizeReached);
        }
        if (this.pendingChangesNumTimesAddedToFullQueue != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_PENDING_CHANGES_NUM_TIMES_ADDED_TO_FULL_QUEUE, MonitorMessages.INFO_REPLICA_DISPNAME_PENDING_CHANGES_ADD_TO_FULL.get(), MonitorMessages.INFO_REPLICA_DESC_PENDING_CHANGES_ADD_TO_FULL.get(), this.pendingChangesNumTimesAddedToFullQueue);
        }
        if (this.pendingChangesNumTimesStallLogged != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_PENDING_CHANGES_NUM_TIMES_STALL_LOGGED, MonitorMessages.INFO_REPLICA_DISPNAME_PENDING_CHANGES_STALL_LOGGED.get(), MonitorMessages.INFO_REPLICA_DESC_PENDING_CHANGES_STALL_LOGGED.get(), this.pendingChangesNumTimesStallLogged);
        }
        if (this.lastUpdateLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_LAST_UPDATE_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_LAST_UPDATE_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_LAST_UPDATE_LATENCY.get(), this.lastUpdateLatencyMillis);
        }
        if (this.recentAverageLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_AVERAGE_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_RECENT_AVERAGE_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_RECENT_AVERAGE_LATENCY.get(), this.recentAverageLatencyMillis);
        }
        if (this.recentMaximumLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_MAXIMUM_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_RECENT_MAX_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_RECENT_MAX_LATENCY.get(), this.recentMaximumLatencyMillis);
        }
        if (this.recentMinimumLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_MINIMUM_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_RECENT_MIN_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_RECENT_MIN_LATENCY.get(), this.recentMinimumLatencyMillis);
        }
        if (this.recentNegativeLatencyUpdateCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_NEGATIVE_LATENCY_UPDATE_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RECENT_NEGATIVE_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_RECENT_NEGATIVE_LATENCY.get(), this.recentNegativeLatencyUpdateCount);
        }
        if (this.recentSumLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_SUM_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_RECENT_SUM_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_RECENT_SUM_LATENCY.get(), this.recentSumLatencyMillis);
        }
        if (this.recentUpdateCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_UPDATE_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RECENT_UPDATE_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RECENT_UPDATE_COUNT.get(), this.recentUpdateCount);
        }
        if (this.totalAverageLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_AVERAGE_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_TOTAL_AVERAGE_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_TOTAL_AVERAGE_LATENCY.get(), this.totalAverageLatencyMillis);
        }
        if (this.totalMaximumLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_MAXIMUM_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_TOTAL_MAX_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_TOTAL_MAX_LATENCY.get(), this.totalMaximumLatencyMillis);
        }
        if (this.totalMinimumLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_MINIMUM_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_TOTAL_MIN_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_TOTAL_MIN_LATENCY.get(), this.totalMinimumLatencyMillis);
        }
        if (this.totalNegativeLatencyUpdateCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_NEGATIVE_LATENCY_UPDATE_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_TOTAL_NEGATIVE_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_TOTAL_NEGATIVE_LATENCY.get(), this.totalNegativeLatencyUpdateCount);
        }
        if (this.totalSumLatencyMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_SUM_LATENCY_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_TOTAL_SUM_LATENCY.get(), MonitorMessages.INFO_REPLICA_DESC_TOTAL_SUM_LATENCY.get(), this.totalSumLatencyMillis);
        }
        if (this.replicationAssuranceSubmittedOperations != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_ASSURANCE_SUBMITTED_OPERATIONS, MonitorMessages.INFO_REPLICA_DISPNAME_REPL_ASSURANCE_SUBMITTED_OPS.get(), MonitorMessages.INFO_REPLICA_DESC_REPL_ASSURANCE_SUBMITTED_OPS.get(), this.replicationAssuranceSubmittedOperations);
        }
        if (this.replicationAssuranceCompletedNormally != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_ASSURANCE_COMPLETED_NORMALLY, MonitorMessages.INFO_REPLICA_DISPNAME_REPL_ASSURANCE_COMPLETED_NORMALLY.get(), MonitorMessages.INFO_REPLICA_DESC_REPL_ASSURANCE_COMPLETED_NORMALLY.get(), this.replicationAssuranceCompletedNormally);
        }
        if (this.replicationAssuranceCompletedAbnormally != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_ASSURANCE_COMPLETED_ABNORMALLY, MonitorMessages.INFO_REPLICA_DISPNAME_REPL_ASSURANCE_COMPLETED_ABNORMALLY.get(), MonitorMessages.INFO_REPLICA_DESC_REPL_ASSURANCE_COMPLETED_ABNORMALLY.get(), this.replicationAssuranceCompletedAbnormally);
        }
        if (this.replicationAssuranceCompletedWithTimeout != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_ASSURANCE_COMPLETED_WITH_TIMEOUT, MonitorMessages.INFO_REPLICA_DISPNAME_REPL_ASSURANCE_COMPLETED_WITH_TIMEOUT.get(), MonitorMessages.INFO_REPLICA_DESC_REPL_ASSURANCE_COMPLETED_WITH_TIMEOUT.get(), this.replicationAssuranceCompletedWithTimeout);
        }
        if (this.replicationAssuranceCompletedWithShutdown != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REPLICATION_ASSURANCE_COMPLETED_WITH_SHUTDOWN, MonitorMessages.INFO_REPLICA_DISPNAME_REPL_ASSURANCE_COMPLETED_WITH_SHUTDOWN.get(), MonitorMessages.INFO_REPLICA_DESC_REPL_ASSURANCE_COMPLETED_WITH_SHUTDOWN.get(), this.replicationAssuranceCompletedWithShutdown);
        }
        if (this.requeueRetryOpSuccessCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_OP_SUCCESS_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_OP_SUCCESS_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_OP_SUCCESS_COUNT.get(), this.requeueRetryOpSuccessCount);
        }
        if (this.requeueRetryOpFailedCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_OP_FAILED_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_OP_FAILED_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_OP_FAILED_COUNT.get(), this.requeueRetryOpFailedCount);
        }
        if (this.requeueRetryAddSuccessCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_ADD_SUCCESS_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_ADD_SUCCESS_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_ADD_SUCCESS_COUNT.get(), this.requeueRetryAddSuccessCount);
        }
        if (this.requeueRetryAddFailedCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_ADD_FAILED_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_ADD_FAILED_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_ADD_FAILED_COUNT.get(), this.requeueRetryAddFailedCount);
        }
        if (this.requeueRetryDeleteSuccessCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_DELETE_SUCCESS_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_DELETE_SUCCESS_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_DELETE_SUCCESS_COUNT.get(), this.requeueRetryDeleteSuccessCount);
        }
        if (this.requeueRetryDeleteFailedCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_DELETE_FAILED_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_DELETE_FAILED_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_DELETE_FAILED_COUNT.get(), this.requeueRetryDeleteFailedCount);
        }
        if (this.requeueRetryModifySuccessCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_MODIFY_SUCCESS_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_MODIFY_SUCCESS_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_MODIFY_SUCCESS_COUNT.get(), this.requeueRetryModifySuccessCount);
        }
        if (this.requeueRetryModifyFailedCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_MODIFY_FAILED_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_MODIFY_FAILED_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_MODIFY_FAILED_COUNT.get(), this.requeueRetryModifyFailedCount);
        }
        if (this.requeueRetryModifyDNSuccessCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_MODIFY_DN_SUCCESS_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_MODIFY_DN_SUCCESS_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_MODIFY_DN_SUCCESS_COUNT.get(), this.requeueRetryModifyDNSuccessCount);
        }
        if (this.requeueRetryModifyDNFailedCount != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_MODIFY_DN_FAILED_COUNT, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_MODIFY_DN_FAILED_COUNT.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_MODIFY_DN_FAILED_COUNT.get(), this.requeueRetryModifyDNFailedCount);
        }
        if (this.requeueRetrySuccessAverageDurationMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_OP_SUCCESS_AVERAGE_DURATION_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_AVERAGE_DURATION.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_AVERAGE_DURATION.get(), this.requeueRetrySuccessAverageDurationMillis);
        }
        if (this.requeueRetrySuccessMaximumDurationMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_OP_SUCCESS_MAXIMUM_DURATION_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_MAX_DURATION.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_MAX_DURATION.get(), this.requeueRetrySuccessMaximumDurationMillis);
        }
        if (this.requeueRetrySuccessTotalDurationMillis != null) {
            ReplicaMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUEUE_RETRY_OP_SUCCESS_TOTAL_DURATION_MILLIS, MonitorMessages.INFO_REPLICA_DISPNAME_RETRY_TOTAL_DURATION.get(), MonitorMessages.INFO_REPLICA_DESC_RETRY_TOTAL_DURATION.get(), this.requeueRetrySuccessTotalDurationMillis);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

