/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.color;

import com.github.weisj.darklaf.components.color.PopupColorChooser;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.SolidColorIcon;
import com.github.weisj.darklaf.transfer.TransferUtil;
import com.github.weisj.darklaf.util.Pair;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.dnd.DropTarget;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class QuickColorChooser
extends JPanel {
    private final SolidColorIcon icon;
    private final JCheckBox checkBox;
    private final JLabel colorLabel;
    private final BiConsumer<Boolean, Color> onStatusChange;
    private Pair<DropTarget, AtomicBoolean> dndSupport;

    public QuickColorChooser(String title, Color color, Consumer<Color> onColorChange) {
        this(title, color, (b, c) -> onColorChange.accept((Color)c), false);
    }

    public QuickColorChooser(String title, Color color, BiConsumer<Boolean, Color> onStatusChange, boolean showCheckBox) {
        this(title, color, onStatusChange, showCheckBox, null);
    }

    public QuickColorChooser(String title, Color color, BiConsumer<Boolean, Color> onStatusChange, boolean showCheckBox, Dimension pickerSize) {
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        if (showCheckBox) {
            this.checkBox = new JCheckBox("\u200b");
            this.checkBox.addActionListener(e -> onStatusChange.accept(this.isSelected(), this.getColor()));
            this.add(this.checkBox);
        } else {
            this.checkBox = null;
        }
        this.icon = pickerSize == null ? new SolidColorIcon(color) : new SolidColorIcon(color, pickerSize.width, pickerSize.height);
        this.colorLabel = new JLabel((Icon)this.icon, 2);
        this.colorLabel.putClientProperty("JToolTip.style", ToolTipStyle.BALLOON);
        this.onStatusChange = onStatusChange;
        QuickColorChooser.attachToComponent(this.colorLabel, this::onColorChange, () -> ((SolidColorIcon)this.icon).getColor());
        this.add(this.colorLabel);
        if (title != null) {
            this.add(new JLabel(title, EmptyIcon.create((int)0), 2));
        }
    }

    public void setDragEnabled(boolean dragEnabled) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (dragEnabled && this.dndSupport == null) {
            this.dndSupport = TransferUtil.setupDnD(this.colorLabel, 1, Color.class, this::getColor, this::setColor, SolidColorIcon::new);
        }
        if (this.dndSupport != null) {
            ((DropTarget)this.dndSupport.getFirst()).setActive(dragEnabled);
            ((AtomicBoolean)this.dndSupport.getSecond()).set(dragEnabled);
        }
    }

    private void onColorChange(Color c) {
        this.onColorChange(c, true);
    }

    private void onColorChange(Color c, boolean notifyCallback) {
        boolean notify = notifyCallback;
        if (notify) {
            boolean bl = notify = !Objects.equals(c, this.icon.getColor());
        }
        if (notify) {
            this.onStatusChange.accept(this.isSelected(), c);
        }
        this.icon.setColor(c);
        this.colorLabel.repaint();
    }

    public QuickColorChooser(String title, Color color, BiConsumer<Boolean, Color> onStatusChange) {
        this(title, color, onStatusChange, true);
    }

    public static void attachToComponent(JComponent component, Consumer<Color> onStatusChange, Supplier<Color> supplier) {
        QuickColorChooser.attachToComponent(component, onStatusChange, supplier, Boolean.TRUE::booleanValue);
    }

    public static void attachToComponent(JComponent component, Consumer<Color> onStatusChange, Supplier<Color> supplier, Supplier<Boolean> activationCheck) {
        PopupColorChooser.attackToComponent(component, onStatusChange, supplier, activationCheck, true);
    }

    @Override
    public void setToolTipText(String text) {
        this.colorLabel.setToolTipText(text);
    }

    public boolean isSelected() {
        return this.checkBox != null && this.checkBox.isSelected();
    }

    public void setSelected(boolean selected) {
        if (this.checkBox != null) {
            this.checkBox.setSelected(selected);
        }
    }

    public Color getColor() {
        return this.icon.getColor();
    }

    public void setColor(Color color) {
        this.setColor(color, true);
    }

    public void setColor(Color color, boolean notifyCallback) {
        this.onColorChange(color, notifyCallback);
    }
}

