/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.spec.config.ConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.CoordProto;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J(\u0010\u0006\u001a\u00020\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0001H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/CoordConfig;", "", "()V", "allowsDomainExpand", "", "coordOpts", "createCoordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "transformX", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "transformY", "defaultCoordProvider", "getCoordName", "", "validateRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "r", "t", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nCoordConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordConfig.kt\norg/jetbrains/letsPlot/core/spec/config/CoordConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class CoordConfig {
    @NotNull
    public static final CoordConfig INSTANCE = new CoordConfig();

    private CoordConfig() {
    }

    public final boolean allowsDomainExpand(@Nullable Object coordOpts) {
        if (coordOpts == null) {
            return true;
        }
        return !Intrinsics.areEqual((Object)this.getCoordName(coordOpts), (Object)"polar");
    }

    @NotNull
    public final CoordProvider createCoordProvider(@Nullable Object coordOpts, @NotNull Transform transformX, @NotNull Transform transformY, @NotNull CoordProvider defaultCoordProvider) {
        DoubleSpan doubleSpan;
        DoubleSpan doubleSpan2;
        Intrinsics.checkNotNullParameter((Object)transformX, (String)"transformX");
        Intrinsics.checkNotNullParameter((Object)transformY, (String)"transformY");
        Intrinsics.checkNotNullParameter((Object)defaultCoordProvider, (String)"defaultCoordProvider");
        if (coordOpts == null) {
            return defaultCoordProvider;
        }
        Map options = coordOpts instanceof Map ? (Map)coordOpts : MapsKt.emptyMap();
        OptionsAccessor accessor = OptionsAccessor.Companion.over(options);
        DoubleSpan doubleSpan3 = accessor.getRangeOrNull("xlim");
        if (doubleSpan3 != null) {
            DoubleSpan it = doubleSpan3;
            boolean bl = false;
            doubleSpan2 = INSTANCE.validateRange(it, transformX);
        } else {
            doubleSpan2 = null;
        }
        DoubleSpan xLim = doubleSpan2;
        DoubleSpan doubleSpan4 = accessor.getRangeOrNull("ylim");
        if (doubleSpan4 != null) {
            DoubleSpan it = doubleSpan4;
            boolean bl = false;
            doubleSpan = INSTANCE.validateRange(it, transformY);
        } else {
            doubleSpan = null;
        }
        DoubleSpan yLim = doubleSpan;
        String coordName = this.getCoordName(coordOpts);
        return Intrinsics.areEqual((Object)coordName, (Object)"flip") ? defaultCoordProvider.with(xLim, yLim, true) : CoordProto.INSTANCE.createCoordProvider(coordName, xLim, yLim, accessor);
    }

    private final String getCoordName(Object coordOpts) {
        String coordName = coordOpts instanceof Map ? ConfigUtil.INSTANCE.featureName((Map)coordOpts) : coordOpts.toString();
        return coordName;
    }

    private final DoubleSpan validateRange(DoubleSpan r, Transform t) {
        DoubleSpan doubleSpan;
        if (t instanceof ContinuousTransform) {
            DoubleSpan ar = ((ContinuousTransform)t).toApplicableDomain(r);
            Double d = ((ContinuousTransform)t).apply(ar.getLowerEnd());
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = ((ContinuousTransform)t).apply(ar.getUpperEnd());
            Intrinsics.checkNotNull((Object)d3);
            doubleSpan = new DoubleSpan(d2, d3.doubleValue());
        } else {
            doubleSpan = r;
        }
        return doubleSpan;
    }
}

