/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0001R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/NumericBreakFormatter;", "", "value", "", "step", "allowMetricPrefix", "", "(DDZ)V", "formatter", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat;", "apply", "", "plot-base"})
public final class NumericBreakFormatter {
    @NotNull
    private NumberFormat formatter;

    public NumericBreakFormatter(double value, double step, boolean allowMetricPrefix) {
        double value2 = value == 0.0 ? 4.9E-323 : Math.abs(value);
        double step2 = step == 0.0 ? value2 / (double)10 : Math.abs(step);
        String type = "f";
        String delimiter = "";
        double domain10Power = Math.log10(Math.abs(value2));
        double step10Power = Math.log10(step2);
        double precision = -step10Power;
        boolean scientificNotation = false;
        if (domain10Power < 0.0 && step10Power < -4.0) {
            scientificNotation = true;
            type = "e";
            precision = domain10Power - step10Power;
        } else if (domain10Power > 7.0 && step10Power > 2.0) {
            scientificNotation = true;
            precision = domain10Power - step10Power;
        }
        if (precision < 0.0) {
            precision = 0.0;
            type = "d";
        }
        precision = Math.ceil(precision - 0.001);
        if (scientificNotation) {
            type = domain10Power > 0.0 && allowMetricPrefix ? "s" : "e";
        } else {
            delimiter = ",";
        }
        this.formatter = new NumberFormat(delimiter + '.' + (int)precision + type);
    }

    @NotNull
    public final String apply(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.formatter.apply((Number)value);
    }
}

