/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;
import org.jetbrains.letsPlot.util.pngj.BufferedStreamFeeder;
import org.jetbrains.letsPlot.util.pngj.Checksum;
import org.jetbrains.letsPlot.util.pngj.ChunkSeqReaderPng;
import org.jetbrains.letsPlot.util.pngj.ErrorBehaviour;
import org.jetbrains.letsPlot.util.pngj.IImageLine;
import org.jetbrains.letsPlot.util.pngj.IImageLineSet;
import org.jetbrains.letsPlot.util.pngj.IImageLineSetFactory;
import org.jetbrains.letsPlot.util.pngj.IdatSet;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.ImageLineSetDefault;
import org.jetbrains.letsPlot.util.pngj.InputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;
import org.jetbrains.letsPlot.util.pngj.Zip;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkLoadBehaviour;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunksList;
import org.jetbrains.letsPlot.util.pngj.chunks.PngMetadata;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0011\b\u0010\u0018\u0000 k2\u00020\u0001:\u0001kB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000208J\u0006\u0010@\u001a\u00020>J\b\u0010A\u001a\u00020\fH\u0004J0\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0*2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00142\u0006\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u0014H\u0004J\u000e\u0010G\u001a\u00020>2\u0006\u0010?\u001a\u000208J\u0006\u0010H\u001a\u00020>J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010I\u001a\u00020\u0005J\b\u0010J\u001a\u0004\u0018\u000101J\u0006\u0010K\u001a\u00020\u0005J \u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020\u00142\u0006\u0010N\u001a\u00020\u00142\u0006\u0010O\u001a\u00020\u0014H\u0004J\u0006\u0010P\u001a\u00020>J\b\u0010Q\u001a\u00020>H\u0002J\u0006\u0010R\u001a\u00020$J\u000e\u0010R\u001a\u00020$2\u0006\u0010S\u001a\u00020\u0014J\u000e\u0010T\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0*J&\u0010T\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0*2\u0006\u0010M\u001a\u00020\u00142\u0006\u0010N\u001a\u00020\u00142\u0006\u0010O\u001a\u00020\u0014J\u0006\u0010U\u001a\u00020>J\u000e\u0010V\u001a\u00020>2\u0006\u0010W\u001a\u00020XJ\u001f\u0010Y\u001a\u00020>2\u0012\u0010Z\u001a\n\u0012\u0006\b\u0001\u0012\u0002080[\"\u000208\u00a2\u0006\u0002\u0010\\J\u0006\u0010]\u001a\u00020>J\u000e\u0010^\u001a\u00020>2\u0006\u0010_\u001a\u00020\u0018J\u0016\u0010`\u001a\u00020>2\u000e\u0010a\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#J\u000e\u0010b\u001a\u00020>2\u0006\u0010c\u001a\u000204J\u000e\u0010d\u001a\u00020>2\u0006\u0010e\u001a\u000204J\u000e\u0010f\u001a\u00020>2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010g\u001a\u00020>2\u0006\u0010h\u001a\u000204J\b\u0010i\u001a\u000208H\u0016J\u0006\u0010j\u001a\u000208R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0018\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020$\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0012\"\u0004\b'\u0010(R\u0018\u0010)\u001a\f\u0012\u0006\b\u0001\u0012\u00020$\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010,\"\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u0002088F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/PngReader;", "", "inputStream", "Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;", "shouldCloseStream", "", "(Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;Z)V", "chunksList", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksList;", "getChunksList", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksList;", "chunkseq", "Lorg/jetbrains/letsPlot/util/pngj/ChunkSeqReaderPng;", "getChunkseq", "()Lorg/jetbrains/letsPlot/util/pngj/ChunkSeqReaderPng;", "curImgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "getCurImgInfo", "()Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "currentChunkGroup", "", "getCurrentChunkGroup", "()I", "errorBehaviour", "Lorg/jetbrains/letsPlot/util/pngj/ErrorBehaviour;", "idatCrca", "Lorg/jetbrains/letsPlot/util/pngj/Checksum;", "getIdatCrca", "()Lorg/jetbrains/letsPlot/util/pngj/Checksum;", "setIdatCrca", "(Lorg/jetbrains/letsPlot/util/pngj/Checksum;)V", "idatCrcb", "getIdatCrcb", "setIdatCrcb", "imageLineSetFactory", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineSetFactory;", "Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "imgInfo", "getImgInfo", "setImgInfo", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "imlinesSet", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineSet;", "isDone", "()Z", "isInterlaced", "setInterlaced", "(Z)V", "metadata", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngMetadata;", "rowNum", "simpleDigest", "", "getSimpleDigest", "()J", "simpleDigestHex", "", "getSimpleDigestHex", "()Ljava/lang/String;", "streamFeeder", "Lorg/jetbrains/letsPlot/util/pngj/BufferedStreamFeeder;", "addChunkToSkip", "", "chunkToSkip", "close", "createChunkSeqReader", "createLineSet", "singleCursor", "nlines", "noffset", "step", "dontSkipChunk", "end", "forceLoadingOfFirstChunks", "getMetadata", "hasMoreRows", "loadAllInterlaced", "nRows", "rowOffset", "rowStep", "prepareSimpleDigestComputation", "readFirstChunks", "readRow", "nrow", "readRows", "readSkippingAllRows", "setChunkLoadBehaviour", "chunkLoadBehaviour", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkLoadBehaviour;", "setChunksToSkip", "chunksToSkip", "", "([Ljava/lang/String;)V", "setCrcCheckDisabled", "setErrorBehaviour", "er", "setLineSetFactory", "factory", "setMaxBytesMetadata", "maxBytesMetadata", "setMaxTotalBytesRead", "maxTotalBytesToRead", "setShouldCloseStream", "setSkipChunkMaxSize", "skipChunkMaxSize", "toString", "toStringCompact", "Companion", "plot-api"})
public class PngReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ImageInfo imgInfo;
    private boolean isInterlaced;
    @Nullable
    private final ChunkSeqReaderPng chunkseq;
    @Nullable
    private final BufferedStreamFeeder streamFeeder;
    @Nullable
    private PngMetadata metadata;
    private int rowNum;
    @Nullable
    private IImageLineSet<? extends IImageLine> imlinesSet;
    @Nullable
    private IImageLineSetFactory<? extends IImageLine> imageLineSetFactory;
    @Nullable
    private Checksum idatCrca;
    @Nullable
    private Checksum idatCrcb;
    @NotNull
    private ErrorBehaviour errorBehaviour;
    public static final long MAX_TOTAL_BYTES_READ_DEFAULT = 901001001L;
    public static final long MAX_BYTES_METADATA_DEFAULT = 5024024L;
    public static final long MAX_CHUNK_SIZE_SKIP = 2024024L;

    @JvmOverloads
    public PngReader(@NotNull InputPngStream inputStream, boolean shouldCloseStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.rowNum = -1;
        this.errorBehaviour = ErrorBehaviour.STRICT;
        this.streamFeeder = new BufferedStreamFeeder(inputStream, 0, 2, null);
        this.streamFeeder.setCloseStream(shouldCloseStream);
        this.chunkseq = this.createChunkSeqReader();
        try {
            if (this.streamFeeder.feedFixed(this.chunkseq, 36) != 36) {
                throw new PngjInputException("Could not read first 36 bytes (PNG signature+IHDR chunk)");
            }
            this.imgInfo = this.chunkseq.getImageInfo();
            this.isInterlaced = this.chunkseq.getDeinterlacer() != null;
            this.setMaxBytesMetadata(5024024L);
            this.setMaxTotalBytesRead(901001001L);
            this.setSkipChunkMaxSize(2024024L);
            this.chunkseq.addChunkToSkip("fdAT");
            this.chunkseq.addChunkToSkip("fcTL");
            ChunksList chunksList = this.chunkseq.getChunksList();
            Intrinsics.checkNotNull((Object)chunksList);
            this.metadata = new PngMetadata(chunksList);
            this.setLineSetFactory(ImageLineSetDefault.Companion.getFactoryInt());
            this.rowNum = -1;
        }
        catch (Exception e) {
            this.streamFeeder.close();
            this.chunkseq.close();
            throw e;
        }
    }

    public /* synthetic */ PngReader(InputPngStream inputPngStream, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(inputPngStream, bl);
    }

    @Nullable
    public final ImageInfo getImgInfo() {
        return this.imgInfo;
    }

    public final void setImgInfo(@Nullable ImageInfo imageInfo) {
        this.imgInfo = imageInfo;
    }

    public final boolean isInterlaced() {
        return this.isInterlaced;
    }

    public final void setInterlaced(boolean bl) {
        this.isInterlaced = bl;
    }

    @Nullable
    public final ChunkSeqReaderPng getChunkseq() {
        return this.chunkseq;
    }

    @Nullable
    public final Checksum getIdatCrca() {
        return this.idatCrca;
    }

    public final void setIdatCrca(@Nullable Checksum checksum) {
        this.idatCrca = checksum;
    }

    @Nullable
    public final Checksum getIdatCrcb() {
        return this.idatCrcb;
    }

    public final void setIdatCrcb(@Nullable Checksum checksum) {
        this.idatCrcb = checksum;
    }

    private final void readFirstChunks() {
        block1: {
            BufferedStreamFeeder bufferedStreamFeeder;
            do {
                ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
                Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
                if (chunkSeqReaderPng.getCurrentChunkGroup() >= 4) break block1;
                bufferedStreamFeeder = this.streamFeeder;
                Intrinsics.checkNotNull((Object)bufferedStreamFeeder);
            } while (bufferedStreamFeeder.feed(this.chunkseq) > 0);
            throw new PngjInputException("Premature ending reading first chunks");
        }
    }

    public final void setChunkLoadBehaviour(@NotNull ChunkLoadBehaviour chunkLoadBehaviour) {
        Intrinsics.checkNotNullParameter((Object)((Object)chunkLoadBehaviour), (String)"chunkLoadBehaviour");
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.setChunkLoadBehaviour(chunkLoadBehaviour);
    }

    @NotNull
    public final ChunksList getChunksList() {
        return this.getChunksList(true);
    }

    @NotNull
    public final ChunksList getChunksList(boolean forceLoadingOfFirstChunks) {
        if (forceLoadingOfFirstChunks) {
            ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
            Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
            if (chunkSeqReaderPng.firstChunksNotYetRead()) {
                this.readFirstChunks();
            }
        }
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        ChunksList chunksList = chunkSeqReaderPng.getChunksList();
        Intrinsics.checkNotNull((Object)chunksList);
        return chunksList;
    }

    public final int getCurrentChunkGroup() {
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        return chunkSeqReaderPng.getCurrentChunkGroup();
    }

    @Nullable
    public final PngMetadata getMetadata() {
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        if (chunkSeqReaderPng.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.metadata;
    }

    @NotNull
    public final IImageLine readRow() {
        return this.readRow(this.rowNum + 1);
    }

    public final boolean hasMoreRows() {
        return this.rowNum < this.getCurImgInfo().getRows() - 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IImageLine readRow(int nrow) {
        IImageLine iImageLine;
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        if (chunkSeqReaderPng.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        if (!this.isInterlaced) {
            void var2_2;
            if (this.imlinesSet == null) {
                this.imlinesSet = this.createLineSet(true, -1, 0, 1);
            }
            IImageLineSet<? extends IImageLine> iImageLineSet = this.imlinesSet;
            Intrinsics.checkNotNull(iImageLineSet);
            IImageLine line2 = iImageLineSet.getImageLine(nrow);
            if (nrow == this.rowNum) {
                return line2;
            }
            if (nrow < this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + nrow);
            }
            while (this.rowNum < nrow) {
                block10: {
                    BufferedStreamFeeder bufferedStreamFeeder;
                    do {
                        IdatSet idatSet = this.chunkseq.getIdatSet();
                        Intrinsics.checkNotNull((Object)idatSet);
                        if (idatSet.isRowReady()) break block10;
                        bufferedStreamFeeder = this.streamFeeder;
                        Intrinsics.checkNotNull((Object)bufferedStreamFeeder);
                    } while (bufferedStreamFeeder.feed(this.chunkseq) >= 1);
                    throw new PngjInputException("premature ending");
                }
                int n = this.rowNum;
                this.rowNum = n + 1;
                IdatSet idatSet = this.chunkseq.getIdatSet();
                Intrinsics.checkNotNull((Object)idatSet);
                Checksum[] checksumArray = new Checksum[]{this.idatCrca, this.idatCrcb};
                idatSet.updateCrcs(checksumArray);
                if (this.rowNum == nrow) {
                    IdatSet idatSet2 = this.chunkseq.getIdatSet();
                    Intrinsics.checkNotNull((Object)idatSet2);
                    byte[] byArray = idatSet2.getUnfilteredRow();
                    Intrinsics.checkNotNull((Object)byArray);
                    line2.readFromPngRaw(byArray, this.getCurImgInfo().getBytesPerRow() + 1, 0, 1);
                    line2.endReadFromPngRaw();
                }
                IdatSet idatSet3 = this.chunkseq.getIdatSet();
                Intrinsics.checkNotNull((Object)idatSet3);
                idatSet3.advanceToNextRow();
            }
            iImageLine = var2_2;
        } else {
            if (this.imlinesSet == null) {
                this.imlinesSet = this.createLineSet(false, this.getCurImgInfo().getRows(), 0, 1);
                this.loadAllInterlaced(this.getCurImgInfo().getRows(), 0, 1);
            }
            this.rowNum = nrow;
            IImageLineSet<? extends IImageLine> iImageLineSet = this.imlinesSet;
            Intrinsics.checkNotNull(iImageLineSet);
            iImageLine = iImageLineSet.getImageLine(nrow);
        }
        return iImageLine;
    }

    @NotNull
    public final IImageLineSet<? extends IImageLine> readRows() {
        return this.readRows(this.getCurImgInfo().getRows(), 0, 1);
    }

    @NotNull
    public final IImageLineSet<? extends IImageLine> readRows(int nRows, int rowOffset, int rowStep) {
        int nRows2 = nRows;
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        if (chunkSeqReaderPng.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        if (nRows2 < 0) {
            nRows2 = (this.getCurImgInfo().getRows() - rowOffset) / rowStep;
        }
        if (rowStep < 1 || rowOffset < 0 || nRows2 == 0 || nRows2 * rowStep + rowOffset > this.getCurImgInfo().getRows()) {
            throw new PngjInputException("bad args");
        }
        if (this.rowNum >= rowOffset) {
            throw new PngjInputException("readRows cannot be mixed with readRow");
        }
        this.imlinesSet = this.createLineSet(false, nRows2, rowOffset, rowStep);
        if (!this.isInterlaced) {
            int m = -1;
            while (m < nRows2 - 1) {
                block9: {
                    BufferedStreamFeeder bufferedStreamFeeder;
                    do {
                        IdatSet idatSet = this.chunkseq.getIdatSet();
                        Intrinsics.checkNotNull((Object)idatSet);
                        if (idatSet.isRowReady()) break block9;
                        bufferedStreamFeeder = this.streamFeeder;
                        Intrinsics.checkNotNull((Object)bufferedStreamFeeder);
                    } while (bufferedStreamFeeder.feed(this.chunkseq) >= 1);
                    throw new PngjInputException("Premature ending");
                }
                int n = this.rowNum;
                this.rowNum = n + 1;
                IdatSet idatSet = this.chunkseq.getIdatSet();
                Intrinsics.checkNotNull((Object)idatSet);
                Checksum[] checksumArray = new Checksum[]{this.idatCrca, this.idatCrcb};
                idatSet.updateCrcs(checksumArray);
                m = (this.rowNum - rowOffset) / rowStep;
                if (this.rowNum >= rowOffset && rowStep * m + rowOffset == this.rowNum) {
                    IImageLineSet<? extends IImageLine> iImageLineSet = this.imlinesSet;
                    Intrinsics.checkNotNull(iImageLineSet);
                    IImageLine line2 = iImageLineSet.getImageLine(this.rowNum);
                    IdatSet idatSet2 = this.chunkseq.getIdatSet();
                    Intrinsics.checkNotNull((Object)idatSet2);
                    byte[] byArray = idatSet2.getUnfilteredRow();
                    Intrinsics.checkNotNull((Object)byArray);
                    line2.readFromPngRaw(byArray, this.getCurImgInfo().getBytesPerRow() + 1, 0, 1);
                    line2.endReadFromPngRaw();
                }
                IdatSet idatSet3 = this.chunkseq.getIdatSet();
                Intrinsics.checkNotNull((Object)idatSet3);
                idatSet3.advanceToNextRow();
            }
        } else {
            this.loadAllInterlaced(nRows2, rowOffset, rowStep);
        }
        IdatSet idatSet = this.chunkseq.getIdatSet();
        Intrinsics.checkNotNull((Object)idatSet);
        idatSet.markAsDone();
        IImageLineSet<? extends IImageLine> iImageLineSet = this.imlinesSet;
        Intrinsics.checkNotNull(iImageLineSet);
        return iImageLineSet;
    }

    public final void setLineSetFactory(@NotNull IImageLineSetFactory<? extends IImageLine> factory2) {
        Intrinsics.checkNotNullParameter(factory2, (String)"factory");
        this.imageLineSetFactory = factory2;
    }

    @NotNull
    protected final IImageLineSet<? extends IImageLine> createLineSet(boolean singleCursor, int nlines, int noffset, int step2) {
        IImageLineSetFactory<? extends IImageLine> iImageLineSetFactory = this.imageLineSetFactory;
        Intrinsics.checkNotNull(iImageLineSetFactory);
        return iImageLineSetFactory.create(this.getCurImgInfo(), singleCursor, nlines, noffset, step2);
    }

    protected final void loadAllInterlaced(int nRows, int rowOffset, int rowStep) {
        if (!(this.chunkseq != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IdatSet idatSet = this.chunkseq.getIdatSet();
        Intrinsics.checkNotNull((Object)idatSet);
        IdatSet idat = idatSet;
        int nread = 0;
        while (true) {
            IdatSet idatSet2 = this.chunkseq.getIdatSet();
            Intrinsics.checkNotNull((Object)idatSet2);
            if (!idatSet2.isRowReady()) {
                BufferedStreamFeeder bufferedStreamFeeder = this.streamFeeder;
                Intrinsics.checkNotNull((Object)bufferedStreamFeeder);
                if (bufferedStreamFeeder.feed(this.chunkseq) > 0) continue;
            }
            IdatSet idatSet3 = this.chunkseq.getIdatSet();
            Intrinsics.checkNotNull((Object)idatSet3);
            if (!idatSet3.isRowReady()) {
                throw new PngjInputException("Premature ending?");
            }
            IdatSet idatSet4 = this.chunkseq.getIdatSet();
            Intrinsics.checkNotNull((Object)idatSet4);
            Checksum[] checksumArray = new Checksum[]{this.idatCrca, this.idatCrcb};
            idatSet4.updateCrcs(checksumArray);
            int rowNumreal = idat.getRowinfo$plot_api().getRowNreal();
            IImageLineSet<? extends IImageLine> iImageLineSet = this.imlinesSet;
            Intrinsics.checkNotNull(iImageLineSet);
            boolean inset = iImageLineSet.hasImageLine(rowNumreal);
            if (inset) {
                IImageLineSet<? extends IImageLine> iImageLineSet2 = this.imlinesSet;
                Intrinsics.checkNotNull(iImageLineSet2);
                IImageLine iImageLine = iImageLineSet2.getImageLine(rowNumreal);
                byte[] byArray = idat.getUnfilteredRow();
                Intrinsics.checkNotNull((Object)byArray);
                iImageLine.readFromPngRaw(byArray, idat.getRowinfo$plot_api().getBuflen(), idat.getRowinfo$plot_api().getOX(), idat.getRowinfo$plot_api().getDX());
                ++nread;
            }
            idat.advanceToNextRow();
            if (nread >= nRows && idat.isDone()) break;
        }
        idat.markAsDone();
        int i = 0;
        int j = rowOffset;
        while (i < nRows) {
            IImageLineSet<? extends IImageLine> iImageLineSet = this.imlinesSet;
            Intrinsics.checkNotNull(iImageLineSet);
            iImageLineSet.getImageLine(j).endReadFromPngRaw();
            ++i;
            j += rowStep;
        }
    }

    public final void readSkippingAllRows() {
        this.setCrcCheckDisabled();
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.addChunkToSkip("IDAT");
        this.chunkseq.addChunkToSkip("fdAT");
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        this.end();
    }

    public final void setMaxTotalBytesRead(long maxTotalBytesToRead) {
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.setMaxTotalBytesRead(maxTotalBytesToRead);
    }

    public final void setMaxBytesMetadata(long maxBytesMetadata) {
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.setMaxBytesMetadata(maxBytesMetadata);
    }

    public final void setSkipChunkMaxSize(long skipChunkMaxSize) {
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.setSkipChunkMaxSize(skipChunkMaxSize);
    }

    public final void setChunksToSkip(String ... chunksToSkip) {
        Intrinsics.checkNotNullParameter((Object)chunksToSkip, (String)"chunksToSkip");
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.setChunksToSkip(Arrays.copyOf(chunksToSkip, chunksToSkip.length));
    }

    public final void addChunkToSkip(@NotNull String chunkToSkip) {
        Intrinsics.checkNotNullParameter((Object)chunkToSkip, (String)"chunkToSkip");
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.addChunkToSkip(chunkToSkip);
    }

    public final void dontSkipChunk(@NotNull String chunkToSkip) {
        Intrinsics.checkNotNullParameter((Object)chunkToSkip, (String)"chunkToSkip");
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.dontSkipChunk(chunkToSkip);
    }

    public final void setShouldCloseStream(boolean shouldCloseStream) {
        BufferedStreamFeeder bufferedStreamFeeder = this.streamFeeder;
        Intrinsics.checkNotNull((Object)bufferedStreamFeeder);
        bufferedStreamFeeder.setCloseStream(shouldCloseStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void end() {
        try {
            ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
            Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
            if (chunkSeqReaderPng.firstChunksNotYetRead()) {
                this.readFirstChunks();
            }
            if (this.chunkseq.getIdatSet() != null) {
                IdatSet idatSet = this.chunkseq.getIdatSet();
                Intrinsics.checkNotNull((Object)idatSet);
                if (!idatSet.isDone()) {
                    IdatSet idatSet2 = this.chunkseq.getIdatSet();
                    Intrinsics.checkNotNull((Object)idatSet2);
                    idatSet2.markAsDone();
                }
            }
            while (!this.chunkseq.isDone()) {
                BufferedStreamFeeder bufferedStreamFeeder = this.streamFeeder;
                Intrinsics.checkNotNull((Object)bufferedStreamFeeder);
                if (bufferedStreamFeeder.feed(this.chunkseq) > 0) continue;
                break;
            }
        }
        finally {
            this.close();
        }
    }

    public final void close() {
        block3: {
            try {
                ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
                if (chunkSeqReaderPng != null) {
                    chunkSeqReaderPng.close();
                }
            }
            catch (Exception e) {
                System.out.println((Object)("error closing chunk sequence:" + e.getMessage()));
            }
            BufferedStreamFeeder bufferedStreamFeeder = this.streamFeeder;
            if (bufferedStreamFeeder == null) break block3;
            bufferedStreamFeeder.close();
        }
    }

    public final void setCrcCheckDisabled() {
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.setCheckCrc(false);
    }

    @NotNull
    protected final ChunkSeqReaderPng createChunkSeqReader() {
        return new ChunkSeqReaderPng(false);
    }

    public final void prepareSimpleDigestComputation() {
        if (this.idatCrca == null) {
            this.idatCrca = Zip.INSTANCE.crc32();
        } else {
            Checksum checksum = this.idatCrca;
            Intrinsics.checkNotNull((Object)checksum);
            checksum.reset();
        }
        if (this.idatCrcb == null) {
            this.idatCrcb = Zip.INSTANCE.adler32();
        } else {
            Checksum checksum = this.idatCrcb;
            Intrinsics.checkNotNull((Object)checksum);
            checksum.reset();
        }
        ImageInfo imageInfo = this.imgInfo;
        Intrinsics.checkNotNull((Object)imageInfo);
        Checksum checksum = this.idatCrca;
        Intrinsics.checkNotNull((Object)checksum);
        imageInfo.updateCrc(checksum);
        Checksum checksum2 = this.idatCrcb;
        Intrinsics.checkNotNull((Object)checksum2);
        ImageInfo imageInfo2 = this.imgInfo;
        Intrinsics.checkNotNull((Object)imageInfo2);
        checksum2.update(imageInfo2.getRows());
    }

    public final long getSimpleDigest() {
        long l;
        if (this.idatCrca == null) {
            l = 0L;
        } else {
            Checksum checksum = this.idatCrca;
            Intrinsics.checkNotNull((Object)checksum);
            long l2 = checksum.getValue();
            Checksum checksum2 = this.idatCrcb;
            Intrinsics.checkNotNull((Object)checksum2);
            l = l2 ^ checksum2.getValue() << 31;
        }
        return l;
    }

    @NotNull
    public final String getSimpleDigestHex() {
        return new NumberFormat("016X").apply((Number)this.getSimpleDigest());
    }

    @NotNull
    public String toString() {
        return this.imgInfo + " interlaced=" + this.isInterlaced;
    }

    @NotNull
    public final String toStringCompact() {
        StringBuilder stringBuilder = new StringBuilder();
        ImageInfo imageInfo = this.imgInfo;
        Intrinsics.checkNotNull((Object)imageInfo);
        return stringBuilder.append(imageInfo.toStringBrief()).append(this.isInterlaced ? "i" : "").toString();
    }

    @NotNull
    public final ImageInfo getCurImgInfo() {
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        ImageInfo imageInfo = chunkSeqReaderPng.getCurImgInfo();
        Intrinsics.checkNotNull((Object)imageInfo);
        return imageInfo;
    }

    public final void setErrorBehaviour(@NotNull ErrorBehaviour er) {
        Intrinsics.checkNotNullParameter((Object)((Object)er), (String)"er");
        this.errorBehaviour = er;
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        chunkSeqReaderPng.setErrorBehaviour(er);
    }

    public final boolean isDone() {
        ChunkSeqReaderPng chunkSeqReaderPng = this.chunkseq;
        Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
        return chunkSeqReaderPng.isDone();
    }

    @JvmOverloads
    public PngReader(@NotNull InputPngStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this(inputStream, false, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/PngReader$Companion;", "", "()V", "MAX_BYTES_METADATA_DEFAULT", "", "MAX_CHUNK_SIZE_SKIP", "MAX_TOTAL_BYTES_READ_DEFAULT", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

