/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jmeter.engine.util.AbstractTransformer;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.StringUtilities;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceFunctionsWithStrings
extends AbstractTransformer {
    private static final Logger log = LoggerFactory.getLogger(ReplaceFunctionsWithStrings.class);
    private static final String FUNCTION_REF_PREFIX = "${";
    private static final String FUNCTION_REF_PREFIX_REGEX_SAFE = "\\${";
    private static final String FUNCTION_REF_SUFFIX = "}";
    private final boolean regexMatch;
    private static final boolean USE_JAVA_REGEX = !JMeterUtils.getPropDefault("jmeter.regex.engine", "oro").equalsIgnoreCase("oro");

    public ReplaceFunctionsWithStrings(CompoundVariable masterFunction, Map<String, String> variables) {
        this(masterFunction, variables, false);
    }

    public ReplaceFunctionsWithStrings(CompoundVariable masterFunction, Map<String, String> variables, boolean regexMatch) {
        this.setMasterFunction(masterFunction);
        this.setVariables((Map)variables);
        this.regexMatch = regexMatch;
    }

    @Override
    public JMeterProperty transformValue(JMeterProperty prop) throws InvalidVariableException {
        if (USE_JAVA_REGEX) {
            return this.transformValueWithJavaRegex(prop);
        }
        return this.transformValueWithOroRegex(prop);
    }

    private JMeterProperty transformValueWithOroRegex(JMeterProperty prop) throws InvalidVariableException {
        Perl5Matcher pm = JMeterUtils.getMatcher();
        Perl5Compiler compiler = new Perl5Compiler();
        String input = prop.getStringValue();
        if (input == null) {
            return prop;
        }
        for (Map.Entry entry : this.getVariables().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.regexMatch) {
                try {
                    org.apache.oro.text.regex.Pattern pattern = compiler.compile(ReplaceFunctionsWithStrings.constructPattern(value));
                    input = Util.substitute((PatternMatcher)pm, (org.apache.oro.text.regex.Pattern)pattern, (Substitution)new StringSubstitution(FUNCTION_REF_PREFIX + key + FUNCTION_REF_SUFFIX), (String)input, (int)-1);
                }
                catch (MalformedPatternException e) {
                    log.warn("Malformed pattern: {}", (Object)value);
                }
                continue;
            }
            input = StringUtilities.substitute(input, value, FUNCTION_REF_PREFIX + key + FUNCTION_REF_SUFFIX);
        }
        return new StringProperty(prop.getName(), input);
    }

    private JMeterProperty transformValueWithJavaRegex(JMeterProperty prop) throws InvalidVariableException {
        String input = prop.getStringValue();
        if (input == null) {
            return prop;
        }
        for (Map.Entry entry : this.getVariables().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.regexMatch) {
                try {
                    Pattern pattern = JMeterUtils.compilePattern(ReplaceFunctionsWithStrings.constructPattern(value));
                    input = pattern.matcher(input).replaceAll(FUNCTION_REF_PREFIX_REGEX_SAFE + key + FUNCTION_REF_SUFFIX);
                }
                catch (PatternSyntaxException e) {
                    log.warn("Malformed pattern: {}", (Object)value);
                }
                continue;
            }
            input = StringUtilities.substitute(input, value, FUNCTION_REF_PREFIX + key + FUNCTION_REF_SUFFIX);
        }
        return new StringProperty(prop.getName(), input);
    }

    private static String constructPattern(String value) {
        if (value.startsWith("(") && value.endsWith(")")) {
            return value;
        }
        return "\\b(" + value + ")\\b";
    }
}

