/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;

public final class GUIFactory {
    private static final Map<String, JMeterGUIComponent> GUI_MAP = new HashMap<String, JMeterGUIComponent>();
    private static final Map<String, ImageIcon> ICON_MAP = new HashMap<String, ImageIcon>();
    private static final Map<String, ImageIcon> DISABLED_ICON_MAP = new HashMap<String, ImageIcon>();

    private GUIFactory() {
    }

    public static ImageIcon getIcon(Class<?> elementClass) {
        return GUIFactory.getIcon(elementClass, true);
    }

    public static ImageIcon getIcon(Class<?> elementClass, boolean enabled) {
        ImageIcon icon;
        String key = elementClass.getName();
        ImageIcon imageIcon = icon = enabled ? ICON_MAP.get(key) : DISABLED_ICON_MAP.get(key);
        if (icon != null) {
            return icon;
        }
        if (elementClass.getSuperclass() != null) {
            return GUIFactory.getIcon(elementClass.getSuperclass(), enabled);
        }
        return null;
    }

    public static JComponent getGUI(Class<?> elementClass) {
        String key = elementClass.getName();
        JComponent gui = (JComponent)((Object)GUI_MAP.get(key));
        if (gui != null) {
            return gui;
        }
        if (elementClass.getSuperclass() != null) {
            return GUIFactory.getGUI(elementClass.getSuperclass());
        }
        return null;
    }

    public static void registerIcon(String key, ImageIcon icon) {
        ICON_MAP.put(key, icon);
    }

    public static void registerDisabledIcon(String key, ImageIcon icon) {
        DISABLED_ICON_MAP.put(key, icon);
    }

    public static void registerGUI(String key, Class<?> guiClass, Class<?> testClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        JMeterGUIComponent gui = guiClass == TestBeanGUI.class ? new TestBeanGUI(testClass) : (JMeterGUIComponent)guiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        GUI_MAP.put(key, gui);
    }
}

