/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Replaceable;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.action.RawTextSearcher;
import org.apache.jmeter.gui.action.RegexpSearcher;
import org.apache.jmeter.gui.action.Searcher;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTreeDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4436834972710248247L;
    private static final Logger logger = LoggerFactory.getLogger(SearchTreeDialog.class);
    private JButton searchButton;
    private JButton nextButton;
    private JButton previousButton;
    private JButton searchAndExpandButton;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JButton replaceAndFindButton;
    private JButton resetSearchButton;
    private JButton cancelButton;
    private JTextField searchTF;
    private JTextField replaceTF;
    private JLabel statusLabel;
    private JCheckBox isRegexpCB;
    private JCheckBox isCaseSensitiveCB;
    private transient Triple<String, Boolean, Boolean> lastSearchConditions = null;
    private final List<JMeterTreeNode> lastSearchResult = new ArrayList<JMeterTreeNode>();
    private int currentSearchIndex;

    public SearchTreeDialog() {
    }

    public SearchTreeDialog(JFrame parent) {
        super(parent, JMeterUtils.getResString("search_tree_title"), false);
        this.init();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -6543764044868772971L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTreeDialog.this.setVisible(false);
            }
        };
        AbstractAction enterAction = new AbstractAction("ENTER"){
            private static final long serialVersionUID = -3661361497864527363L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTreeDialog.this.doSearch(actionEvent);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        actionMap.put(enterAction.getValue("Name"), enterAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        inputMap.put(KeyStrokes.ENTER, enterAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.searchTF = new JTextField(20);
        this.searchTF.setAlignmentY(0.0f);
        if (this.lastSearchConditions != null) {
            this.searchTF.setText((String)this.lastSearchConditions.getLeft());
            this.isCaseSensitiveCB.setSelected((Boolean)this.lastSearchConditions.getMiddle());
            this.isRegexpCB.setSelected((Boolean)this.lastSearchConditions.getRight());
        }
        this.replaceTF = new JTextField(20);
        this.replaceTF.setAlignmentX(0.0f);
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setPreferredSize(new Dimension(100, 20));
        this.statusLabel.setMinimumSize(new Dimension(100, 20));
        this.isRegexpCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_regexp"), false);
        this.isCaseSensitiveCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_case"), true);
        JFactory.small((JCheckBox)this.isRegexpCB);
        JFactory.small((JCheckBox)this.isCaseSensitiveCB);
        JPanel searchCriterionPanel = new JPanel(new FlowLayout(1));
        searchCriterionPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("search_matching")));
        searchCriterionPanel.add(this.isCaseSensitiveCB);
        searchCriterionPanel.add(this.isRegexpCB);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout((LayoutManager)new MigLayout("fillx, wrap 2", "[][fill,grow]"));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(7, 3, 3, 3));
        searchPanel.add(JMeterUtils.labelFor(this.searchTF, "search_text_field"));
        searchPanel.add(this.searchTF);
        searchPanel.add(JMeterUtils.labelFor(this.replaceTF, "search_text_replace"));
        searchPanel.add(this.replaceTF);
        searchPanel.add((Component)this.statusLabel, "span 2");
        searchPanel.add((Component)searchCriterionPanel, "span 2");
        this.resetSearchButton = SearchTreeDialog.createButton("menu_search_reset");
        this.resetSearchButton.addActionListener(this);
        searchPanel.add(this.resetSearchButton);
        JPanel buttonsPanel = new JPanel(new GridLayout(9, 1));
        this.searchButton = SearchTreeDialog.createButton("search_search_all");
        this.searchButton.addActionListener(this);
        this.nextButton = SearchTreeDialog.createButton("search_next");
        this.nextButton.addActionListener(this);
        this.previousButton = SearchTreeDialog.createButton("search_previous");
        this.previousButton.addActionListener(this);
        this.searchAndExpandButton = SearchTreeDialog.createButton("search_search_all_expand");
        this.searchAndExpandButton.addActionListener(this);
        this.replaceButton = SearchTreeDialog.createButton("search_replace");
        this.replaceButton.addActionListener(this);
        this.replaceAllButton = SearchTreeDialog.createButton("search_replace_all");
        this.replaceAllButton.addActionListener(this);
        this.replaceAndFindButton = SearchTreeDialog.createButton("search_replace_and_find");
        this.replaceAndFindButton.addActionListener(this);
        this.cancelButton = SearchTreeDialog.createButton("cancel");
        this.cancelButton.addActionListener(this);
        buttonsPanel.add(this.nextButton);
        buttonsPanel.add(this.previousButton);
        buttonsPanel.add(this.searchButton);
        buttonsPanel.add(this.searchAndExpandButton);
        buttonsPanel.add(Box.createVerticalStrut(30));
        buttonsPanel.add(this.replaceButton);
        buttonsPanel.add(this.replaceAllButton);
        buttonsPanel.add(this.replaceAndFindButton);
        buttonsPanel.add(this.cancelButton);
        JPanel searchAndReplacePanel = new JPanel();
        searchAndReplacePanel.setLayout(new BorderLayout());
        searchAndReplacePanel.add((Component)searchPanel, "Center");
        searchAndReplacePanel.add((Component)buttonsPanel, "East");
        this.getContentPane().add(searchAndReplacePanel);
        this.searchTF.requestFocusInWindow();
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    private static JButton createButton(String messageKey) {
        return new JButton(JMeterUtils.getResString(messageKey));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.statusLabel.setText("");
        if (source == this.cancelButton) {
            this.searchTF.requestFocusInWindow();
            this.setVisible(false);
        } else if (source == this.searchButton || source == this.searchAndExpandButton) {
            this.doSearch(e);
        } else if (source == this.nextButton || source == this.previousButton) {
            this.doNavigateToSearchResult(source == this.nextButton);
        } else if (source == this.replaceAllButton) {
            this.doReplaceAll(e);
        } else if (!this.lastSearchResult.isEmpty() && source == this.replaceButton) {
            this.doReplace();
        } else if (source == this.replaceAndFindButton) {
            if (!this.lastSearchResult.isEmpty()) {
                this.doReplace();
            }
            this.doNavigateToSearchResult(true);
        } else if (source == this.resetSearchButton) {
            SearchTreeDialog.doResetSearch(e);
        }
    }

    private static void doResetSearch(ActionEvent event) {
        ActionRouter.getInstance().doActionNow(new ActionEvent(event.getSource(), event.getID(), "search_reset"));
    }

    private void doReplace() {
        JMeterTreeNode currentNode;
        GuiPackage.getInstance().updateCurrentNode();
        int nbReplacements = 0;
        if (this.currentSearchIndex >= 0 && (currentNode = this.lastSearchResult.get(this.currentSearchIndex)) != null) {
            boolean caseSensitiveReplacement;
            String wordToSearch = this.searchTF.getText();
            String wordToReplace = this.replaceTF.getText();
            String regex = this.isRegexpCB.isSelected() ? wordToSearch : Pattern.quote(wordToSearch);
            Pair<Integer, JMeterTreeNode> pair = SearchTreeDialog.doReplacementInCurrentNode(currentNode, regex, wordToReplace, caseSensitiveReplacement = this.isCaseSensitiveCB.isSelected());
            if (pair != null) {
                nbReplacements = (Integer)pair.getLeft();
                GuiPackage.getInstance().updateCurrentGui();
                GuiPackage.getInstance().getMainFrame().repaint();
            }
        }
        this.statusLabel.setText(MessageFormat.format("Replaced {0} occurrences", nbReplacements));
    }

    private JMeterTreeNode doNavigateToSearchResult(boolean isNext) {
        boolean doSearchAgain;
        boolean bl = doSearchAgain = this.lastSearchConditions == null || !Triple.of((Object)this.searchTF.getText(), (Object)this.isCaseSensitiveCB.isSelected(), (Object)this.isRegexpCB.isSelected()).equals(this.lastSearchConditions);
        if (doSearchAgain) {
            String wordToSearch = this.searchTF.getText();
            if (StringUtils.isEmpty((CharSequence)wordToSearch)) {
                this.lastSearchConditions = null;
                return null;
            }
            this.lastSearchConditions = Triple.of((Object)wordToSearch, (Object)this.isCaseSensitiveCB.isSelected(), (Object)this.isRegexpCB.isSelected());
            Searcher searcher = this.createSearcher(wordToSearch);
            this.searchInTree(GuiPackage.getInstance(), searcher, wordToSearch);
        }
        if (!this.lastSearchResult.isEmpty()) {
            if (isNext) {
                ++this.currentSearchIndex;
                this.currentSearchIndex %= this.lastSearchResult.size();
            } else {
                this.currentSearchIndex = this.currentSearchIndex > 0 ? (this.currentSearchIndex = this.currentSearchIndex - 1) : this.lastSearchResult.size() - 1;
            }
            JMeterTreeNode selectedNode = this.lastSearchResult.get(this.currentSearchIndex);
            TreePath selection = new TreePath(selectedNode.getPath());
            GuiPackage.getInstance().getMainFrame().getTree().setSelectionPath(selection);
            GuiPackage.getInstance().getMainFrame().getTree().scrollPathToVisible(selection);
            return selectedNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSearch(ActionEvent e) {
        boolean expand = e.getSource() == this.searchAndExpandButton;
        String wordToSearch = this.searchTF.getText();
        if (StringUtils.isEmpty((CharSequence)wordToSearch)) {
            this.lastSearchConditions = null;
            return;
        }
        this.lastSearchConditions = Triple.of((Object)wordToSearch, (Object)this.isCaseSensitiveCB.isSelected(), (Object)this.isRegexpCB.isSelected());
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "search_reset"));
        Searcher searcher = this.createSearcher(wordToSearch);
        GuiPackage guiPackage = GuiPackage.getInstance();
        guiPackage.beginUndoTransaction();
        int numberOfMatches = 0;
        try {
            Pair<Integer, Set<JMeterTreeNode>> result = this.searchInTree(guiPackage, searcher, wordToSearch);
            numberOfMatches = (Integer)result.getLeft();
            SearchTreeDialog.markConcernedNodes(expand, (Set)result.getRight());
        }
        finally {
            guiPackage.endUndoTransaction();
        }
        GuiPackage.getInstance().getMainFrame().repaint();
        this.searchTF.requestFocusInWindow();
        this.statusLabel.setText(MessageFormat.format(JMeterUtils.getResString("search_tree_matches"), numberOfMatches));
    }

    private Searcher createSearcher(String wordToSearch) {
        if (this.isRegexpCB.isSelected()) {
            return new RegexpSearcher(this.isCaseSensitiveCB.isSelected(), wordToSearch);
        }
        return new RawTextSearcher(this.isCaseSensitiveCB.isSelected(), wordToSearch);
    }

    private Pair<Integer, Set<JMeterTreeNode>> searchInTree(GuiPackage guiPackage, Searcher searcher, String wordToSearch) {
        int numberOfMatches = 0;
        JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
        LinkedHashSet<JMeterTreeNode> nodes = new LinkedHashSet<JMeterTreeNode>();
        for (JMeterTreeNode jMeterTreeNode : jMeterTreeModel.getNodesOfType(Searchable.class)) {
            try {
                Searchable searchable = (Searchable)jMeterTreeNode.getUserObject();
                List<String> searchableTokens = searchable.getSearchableTokens();
                boolean result = searcher.search(searchableTokens);
                if (!result) continue;
                ++numberOfMatches;
                nodes.add(jMeterTreeNode);
            }
            catch (Exception ex) {
                logger.error("Error occurred searching for word:{} in node:{}", new Object[]{wordToSearch, jMeterTreeNode.getName(), ex});
            }
        }
        this.currentSearchIndex = -1;
        this.lastSearchResult.clear();
        this.lastSearchResult.addAll(nodes);
        return Pair.of((Object)numberOfMatches, nodes);
    }

    private static void markConcernedNodes(boolean expand, Set<? extends JMeterTreeNode> nodes) {
        GuiPackage guiInstance = GuiPackage.getInstance();
        JTree jTree = guiInstance.getMainFrame().getTree();
        for (JMeterTreeNode jMeterTreeNode : nodes) {
            jMeterTreeNode.setMarkedBySearch(true);
            if (!expand) continue;
            if (jMeterTreeNode.isLeaf()) {
                jTree.expandPath(new TreePath(((JMeterTreeNode)jMeterTreeNode.getParent()).getPath()));
                continue;
            }
            jTree.expandPath(new TreePath(jMeterTreeNode.getPath()));
        }
    }

    private void doReplaceAll(ActionEvent e) {
        boolean expand = e.getSource() == this.searchAndExpandButton;
        String wordToSearch = this.searchTF.getText();
        String wordToReplace = this.replaceTF.getText();
        if (StringUtils.isEmpty((CharSequence)wordToReplace)) {
            return;
        }
        GuiPackage.getInstance().updateCurrentNode();
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "search_reset"));
        Searcher searcher = this.createSearcher(wordToSearch);
        String regex = this.isRegexpCB.isSelected() ? wordToSearch : Pattern.quote(wordToSearch);
        GuiPackage guiPackage = GuiPackage.getInstance();
        boolean caseSensitiveReplacement = this.isCaseSensitiveCB.isSelected();
        int totalReplaced = 0;
        Pair<Integer, Set<JMeterTreeNode>> result = this.searchInTree(guiPackage, searcher, wordToSearch);
        Set matchingNodes = (Set)result.getRight();
        HashSet<JMeterTreeNode> replacedNodes = new HashSet<JMeterTreeNode>();
        for (JMeterTreeNode jMeterTreeNode : matchingNodes) {
            Pair<Integer, JMeterTreeNode> pair = SearchTreeDialog.doReplacementInCurrentNode(jMeterTreeNode, regex, wordToReplace, caseSensitiveReplacement);
            if (pair == null) continue;
            totalReplaced += ((Integer)pair.getLeft()).intValue();
            replacedNodes.add((JMeterTreeNode)pair.getRight());
        }
        this.statusLabel.setText(MessageFormat.format("Replaced {0} occurrences", totalReplaced));
        SearchTreeDialog.markConcernedNodes(expand, replacedNodes);
        if (totalReplaced > 0) {
            GuiPackage.getInstance().refreshCurrentGui();
        }
        GuiPackage.getInstance().getMainFrame().repaint();
        this.searchTF.requestFocusInWindow();
    }

    private static Pair<Integer, JMeterTreeNode> doReplacementInCurrentNode(JMeterTreeNode jMeterTreeNode, String regex, String replaceBy, boolean caseSensitiveReplacement) {
        try {
            Replaceable replaceable;
            int numberOfReplacements;
            if (jMeterTreeNode.getUserObject() instanceof Replaceable && (numberOfReplacements = (replaceable = (Replaceable)jMeterTreeNode.getUserObject()).replace(regex, replaceBy, caseSensitiveReplacement)) > 0) {
                if (logger.isInfoEnabled()) {
                    logger.info("Replaced {} in element:{}", (Object)numberOfReplacements, (Object)((TestElement)jMeterTreeNode.getUserObject()).getName());
                }
                return Pair.of((Object)numberOfReplacements, (Object)jMeterTreeNode);
            }
        }
        catch (Exception ex) {
            logger.error("Error occurred replacing data in node:{}", (Object)jMeterTreeNode.getName(), (Object)ex);
        }
        return null;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.searchTF.requestFocusInWindow();
    }
}

