/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.resourcehandler.webapp.config.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>
 * Package-private utility class for determining which specifications are available
 * in the current process. 
 * </p>
 *
 * @author Leonardo Uribe
 */
final class _ExternalSpecifications
{

    private static final Log log = LogFactory.getLog(_ExternalSpecifications.class);

    private static volatile Boolean servlet30Available;

    /**
     * This method determines if servlet 3.0 is present.
     *
     * @return true if servlet 3.0 is available, false otherwise.
     */
    public static boolean isServlet30Available()
    {
        if (servlet30Available == null)
        {
            try
            {
                servlet30Available = (Class.forName("javax.servlet.ServletRegistration") != null);
            }
            catch(Throwable t)
            {
                if (log.isTraceEnabled())
                {
                    log.trace("Cannot load servlet 3.0 class (could be normal)", t);
                }
                servlet30Available = Boolean.FALSE;
            }
    
            log.info("MyFaces commons ResourceHandler Servlet 3.0 container support " + (servlet30Available ? "enabled" : "disabled"));
        }
        return servlet30Available; 
    }

    /**
     * this class should not be instantiated.
     */
    private _ExternalSpecifications()
    {
    }

}
