/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.push;

import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.component.UIComponent;
import jakarta.faces.convert.Converter;


// Generated from class org.apache.myfaces.push.AbstractWebsocketComponent.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class WebsocketComponent extends org.apache.myfaces.push.AbstractWebsocketComponent
{

    static public final String COMPONENT_FAMILY =
        "jakarta.faces.Output";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.WebsocketComponent";


    public WebsocketComponent()
    {
        setRendererType("org.apache.myfaces.WebsocketComponent");
    }

    @Override    
    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }


    
    
    // Property: channel

    public String getChannel()
    {
        return (String) getStateHelper().eval(PropertyKeys.channel);
    }
    
    public void setChannel(String channel)
    {
        getStateHelper().put(PropertyKeys.channel, channel ); 
    }
    // Property: scope

    public String getScope()
    {
        return (String) getStateHelper().eval(PropertyKeys.scope);
    }
    
    public void setScope(String scope)
    {
        getStateHelper().put(PropertyKeys.scope, scope ); 
    }
    // Property: user

    public String getUser()
    {
        return (String) getStateHelper().eval(PropertyKeys.user);
    }
    
    public void setUser(String user)
    {
        getStateHelper().put(PropertyKeys.user, user ); 
    }
    // Property: onopen

    public String getOnopen()
    {
        return (String) getStateHelper().eval(PropertyKeys.onopen);
    }
    
    public void setOnopen(String onopen)
    {
        getStateHelper().put(PropertyKeys.onopen, onopen ); 
    }
    // Property: onmessage

    public String getOnmessage()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmessage);
    }
    
    public void setOnmessage(String onmessage)
    {
        getStateHelper().put(PropertyKeys.onmessage, onmessage ); 
    }
    // Property: onclose

    public String getOnclose()
    {
        return (String) getStateHelper().eval(PropertyKeys.onclose);
    }
    
    public void setOnclose(String onclose)
    {
        getStateHelper().put(PropertyKeys.onclose, onclose ); 
    }
    // Property: connected

    public boolean isConnected()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.connected, true);
    }
    
    public void setConnected(boolean connected)
    {
        getStateHelper().put(PropertyKeys.connected, connected ); 
    }
    // Property: initComponentId

    public String getInitComponentId()
    {
        return (String) getStateHelper().eval(PropertyKeys.initComponentId);
    }
    
    public void setInitComponentId(String initComponentId)
    {
        getStateHelper().put(PropertyKeys.initComponentId, initComponentId ); 
    }

    
        enum PropertyKeys
    {
             channel
        , scope
        , user
        , onopen
        , onmessage
        , onclose
        , connected
        , initComponentId
        }

                     }
