"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const chai_1 = require("chai");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const mona_dish_1 = require("mona-dish");
const Const_1 = require("../../impl/core/Const");
var defaultMyFacesNamespaces = StandardInits_1.StandardInits.defaultMyFacesNamespaces;
const querystring_1 = require("querystring");
const Lang_1 = require("../../impl/util/Lang");
var ofAssoc = Lang_1.ExtLang.ofAssoc;
let issueStdReq = function (element) {
    faces.ajax.request(element, null, {
        execute: "input_1",
        render: "@form",
        params: {
            pass1: "pass1",
            pass2: "pass2"
        }
    });
};
(0, mocha_1.describe)('Namespacing tests', function () {
    let oldFlatMap = null;
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFacesNamespaces();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.jsfAjaxResponse = sinon.spy(global.faces.ajax, "response");
                oldFlatMap = Array.prototype["flatMap"];
                window["Es2019Array"] = mona_dish_1._Es2019Array;
                delete Array.prototype["flatMap"];
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
        if (oldFlatMap) {
            Array.prototype["flatMap"] = oldFlatMap;
            oldFlatMap = null;
        }
    });
    (0, mocha_1.it)('must send the element identifiers properly encoded', function () {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            global["debug3"] = true;
            faces.ajax.request(document.getElementById("jd_0:input_2"), null, {
                execute: ":input_1",
                render: ":blarg :input_2",
                params: {
                    pass1: "pass1",
                    pass2: "pass2"
                }
            });
            (0, chai_1.expect)(send.called).to.be.true;
            let argsVal = send.args[0][0];
            let arsArr = argsVal.split("&");
            let resultsMap = {};
            for (let val of arsArr) {
                let keyVal = val.split("=");
                resultsMap[keyVal[0]] = keyVal[1];
            }
            (0, chai_1.expect)(resultsMap["pass1"]).to.eq("pass1");
            (0, chai_1.expect)(resultsMap["pass2"]).to.eq("pass2");
            (0, chai_1.expect)(!!resultsMap["render"]).to.be.false;
            (0, chai_1.expect)(!!resultsMap["execute"]).to.be.false;
            (0, chai_1.expect)(Const_1.P_WINDOW_ID in resultsMap).to.be.false;
            (0, chai_1.expect)(Const_1.P_VIEWSTATE in resultsMap).to.be.true;
            (0, chai_1.expect)(resultsMap[Const_1.P_AJAX_SOURCE]).to.eq((0, querystring_1.escape)("jd_0:input_2"));
            (0, chai_1.expect)(resultsMap[Const_1.P_AJAX]).to.eq("true");
            (0, chai_1.expect)(resultsMap[Const_1.P_RENDER]).to.eq((0, querystring_1.escape)("jd_0:blarg jd_0:input_2"));
            (0, chai_1.expect)(resultsMap[Const_1.P_EXECUTE]).to.eq((0, querystring_1.escape)("jd_0:input_1 jd_0:input_2"));
        }
        finally {
            send.restore();
        }
    });
    (0, mocha_1.it)('must send the element identifiers properly encoded 2', function () {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            faces.ajax.request(document.getElementById("jd_0:input_2"), null, {
                execute: "jd_0:input_1",
                render: ":blarg jd_0:input_2",
                params: {
                    pass1: "pass1",
                    pass2: "pass2"
                }
            });
            (0, chai_1.expect)(send.called).to.be.true;
            let argsVal = send.args[0][0];
            let arsArr = argsVal.split("&");
            let resultsMap = {};
            for (let val of arsArr) {
                let keyVal = val.split("=");
                resultsMap[keyVal[0]] = keyVal[1];
            }
            (0, chai_1.expect)(resultsMap["pass1"]).to.eq("pass1");
            (0, chai_1.expect)(resultsMap["pass2"]).to.eq("pass2");
            (0, chai_1.expect)(!!resultsMap["render"]).to.be.false;
            (0, chai_1.expect)(!!resultsMap["execute"]).to.be.false;
            (0, chai_1.expect)(Const_1.P_WINDOW_ID in resultsMap).to.be.false;
            (0, chai_1.expect)(Const_1.P_VIEWSTATE in resultsMap).to.be.true;
            (0, chai_1.expect)(resultsMap[Const_1.P_AJAX_SOURCE]).to.eq((0, querystring_1.escape)("jd_0:input_2"));
            (0, chai_1.expect)(resultsMap[Const_1.P_AJAX]).to.eq("true");
            (0, chai_1.expect)(resultsMap[Const_1.P_RENDER]).to.eq((0, querystring_1.escape)("jd_0:blarg jd_0:input_2"));
            (0, chai_1.expect)(resultsMap[Const_1.P_EXECUTE]).to.eq((0, querystring_1.escape)("jd_0:input_1 jd_0:input_2"));
        }
        finally {
            send.restore();
        }
    });
    (0, mocha_1.it)('must get name prefixed viewstate properly', function () {
        var _a, _b, _c;
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            (0, mona_dish_1.DQ$)(`[name*='${Const_1.P_VIEWSTATE}']`).attr("name").value = `jd_0:${Const_1.P_VIEWSTATE}`;
            (0, mona_dish_1.DQ$)(`[name*='${Const_1.P_VIEWSTATE}']`).val = "booga";
            faces.ajax.request(document.getElementById("jd_0:input_2"), null, {
                execute: "jd_0:input_1",
                render: ":blarg jd_0:input_2",
                params: {
                    pass1: "pass1",
                    pass2: "pass2"
                }
            });
            (0, chai_1.expect)(send.called).to.be.true;
            let argsVal = send.args[0][0];
            let arsArr = argsVal.split("&");
            let resultsMap = {};
            for (let val of arsArr) {
                let keyVal = val.split("=");
                resultsMap[unescape(keyVal[0])] = unescape(keyVal[1]);
            }
            const NAMING_CONTAINER_PREF = "jd_0:";
            (0, chai_1.expect)(resultsMap[NAMING_CONTAINER_PREF + "pass1"]).to.eq("pass1");
            (0, chai_1.expect)(resultsMap[NAMING_CONTAINER_PREF + "pass2"]).to.eq("pass2");
            (0, chai_1.expect)(!!resultsMap["render"]).to.be.false;
            (0, chai_1.expect)(!!resultsMap["execute"]).to.be.false;
            let hasWindowdId = (_a = ofAssoc(resultsMap).filter(data => data[0].indexOf(Const_1.P_WINDOW_ID) != -1)) === null || _a === void 0 ? void 0 : _a[0];
            let hasViewState = (_b = ofAssoc(resultsMap).filter(data => data[0].indexOf(Const_1.P_VIEWSTATE) != -1)) === null || _b === void 0 ? void 0 : _b[0];
            (0, chai_1.expect)(!!hasWindowdId).to.be.false;
            (0, chai_1.expect)(!!hasViewState).to.be.true;
            let viewState = (_c = ofAssoc(resultsMap).filter(data => data[0].indexOf(Const_1.P_VIEWSTATE) != -1).map(item => item[1])) === null || _c === void 0 ? void 0 : _c[0];
            (0, chai_1.expect)(viewState).to.eq("booga");
            (0, chai_1.expect)(resultsMap[NAMING_CONTAINER_PREF + Const_1.P_AJAX_SOURCE]).to.eq("jd_0:input_2");
            (0, chai_1.expect)(resultsMap[NAMING_CONTAINER_PREF + Const_1.P_AJAX]).to.eq("true");
            (0, chai_1.expect)(resultsMap[NAMING_CONTAINER_PREF + Const_1.P_RENDER]).to.eq("jd_0:blarg jd_0:input_2");
            (0, chai_1.expect)(resultsMap[NAMING_CONTAINER_PREF + Const_1.P_EXECUTE]).to.eq("jd_0:input_1 jd_0:input_2");
        }
        finally {
            send.restore();
        }
    });
});
//# sourceMappingURL=NamespacesRequestTest.spec.js.map