/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.extensions.validator.core;

import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/**
 * ExtVal artifacts supported by the {@link org.apache.myfaces.extensions.validator.core.InformationProviderBean}
 *
 * @author Gerhard Petracek
 * @since 1.x.1
 */
@UsageInformation({UsageCategory.API})
public enum CustomInformation
{
    BASE_PACKAGE,

    COMPONENT_META_DATA_EXTRACTOR,
    VALIDATION_PARAMETER_EXTRACTOR,

    VALIDATION_STRATEGY_POSTFIX,
    VALIDATION_ERROR_MESSAGE_RESOLVER_POSTFIX,
    META_DATA_TRANSFORMER_POSTFIX,

    VALIDATION_STRATEGY_TO_MSG_RESOLVER_NAME_MAPPER,
    META_DATA_TO_VALIDATION_STRATEGY_NAME_MAPPER,
    VALIDATION_STRATEGY_TO_META_DATA_TRANSFORMER_NAME_MAPPER,

    STARTUP_LISTENER,
    COMPONENT_INITIALIZER,
    VALIDATION_EXCEPTION_INTERCEPTOR,
    PROPERTY_VALIDATION_INTERCEPTOR,
    META_DATA_EXTRACTION_INTERCEPTOR,

    MESSAGE_RESOLVER_FACTORY,
    VALIDATION_STRATEGY_FACTORY,
    COMPONENT_META_DATA_EXTRACTOR_FACTORY,
    VALIDATION_PARAMETER_EXTRACTOR_FACTORY,
    VALIDATION_PARAMETER_FACTORY,
    META_DATA_TRANSFORMER_FACTORY,
    FACES_MESSAGE_FACTORY,
    STORAGE_MANAGER_FACTORY,

    MESSAGE_BUNDLE_NAME,
    STATIC_STRATEGY_MAPPING_SOURCE,

    META_DATA_STORAGE_FILTER
}
