/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.openjpa.kernel.Filters;

public class PrototypeFactory<K, T> {
    private Map<K, Class<? extends T>> _registry = new TreeMap<K, Class<? extends T>>();

    public void register(K key, Class<? extends T> prototype) {
        this._registry.put(key, prototype);
    }

    public T newInstance(K key, Object ... args) {
        return this._registry.containsKey(key) ? (T)this.newInstance(this._registry.get(key), args) : null;
    }

    public Set<K> getRegisteredKeys() {
        return Collections.unmodifiableSet(this._registry.keySet());
    }

    private T newInstance(Class<? extends T> type, Object ... args) {
        try {
            return this.findConstructor(type, this.getConstructorParameterTypes(args)).newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    Class<?>[] getConstructorParameterTypes(Object ... args) {
        if (args == null || args.length == 0) {
            return new Class[0];
        }
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i] == null ? Object.class : args[i].getClass();
        }
        return types;
    }

    Constructor<? extends T> findConstructor(Class<? extends T> cls, Class<?>[] types) {
        try {
            return cls.getConstructor(types);
        }
        catch (Exception e) {
            Constructor<?>[] constructors;
            for (Constructor<?> cons : constructors = cls.getConstructors()) {
                Class<?>[] paramTypes = cons.getParameterTypes();
                boolean match = false;
                if (paramTypes.length == types.length) {
                    for (int i = 0; i < paramTypes.length && (match = paramTypes[i].isAssignableFrom(Filters.wrap(types[i]))); ++i) {
                    }
                }
                if (!match) continue;
                return cons;
            }
            throw new RuntimeException();
        }
    }
}

