/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.InstrumentationFactory;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InternalException;

public class ClassRedefiner {
    private static final Localizer _loc = Localizer.forPackage(ClassRedefiner.class);
    private static Boolean _canRedefine = null;

    public static void redefineClasses(OpenJPAConfiguration conf, final Map<Class<?>, byte[]> classes) {
        block9: {
            Log log = conf.getLog("openjpa.Enhance");
            if (classes == null || classes.size() == 0 || !ClassRedefiner.canRedefineClasses(log)) {
                return;
            }
            Instrumentation inst = null;
            ClassFileTransformer t = null;
            try {
                inst = InstrumentationFactory.getInstrumentation(log);
                Class[] array = classes.keySet().toArray(new Class[classes.size()]);
                if (JavaVersions.VERSION >= 6) {
                    log.trace(_loc.get("retransform-types", classes.keySet()));
                    t = new ClassFileTransformer(){

                        @Override
                        public byte[] transform(ClassLoader loader, String clsName, Class<?> classBeingRedefined, ProtectionDomain pd, byte[] classfileBuffer) {
                            return (byte[])classes.get(classBeingRedefined);
                        }
                    };
                    Method meth = inst.getClass().getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE);
                    meth.invoke((Object)inst, t, true);
                    meth = inst.getClass().getMethod("retransformClasses", array.getClass());
                    meth.invoke((Object)inst, new Object[]{array});
                } else {
                    log.trace(_loc.get("redefine-types", classes.keySet()));
                    ClassDefinition[] defs = new ClassDefinition[array.length];
                    for (int i = 0; i < defs.length; ++i) {
                        defs[i] = new ClassDefinition(array[i], classes.get(array[i]));
                    }
                    inst.redefineClasses(defs);
                }
                if (inst == null || t == null) break block9;
                inst.removeTransformer(t);
            }
            catch (Exception e) {
                try {
                    throw new InternalException(e);
                }
                catch (Throwable throwable) {
                    if (inst != null && t != null) {
                        inst.removeTransformer(t);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static boolean canRedefineClasses(Log log) {
        if (_canRedefine == null) {
            try {
                Instrumentation inst = InstrumentationFactory.getInstrumentation(log);
                _canRedefine = inst == null ? Boolean.FALSE : (JavaVersions.VERSION == 5 ? Boolean.TRUE : (Boolean)Instrumentation.class.getMethod("isRetransformClassesSupported", new Class[0]).invoke((Object)inst, new Object[0]));
            }
            catch (Exception e) {
                _canRedefine = Boolean.FALSE;
            }
        }
        return _canRedefine;
    }
}

