/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.security.AccessController;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.schema.DriverDataSource;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.jdbc.ConfiguringConnectionDecorator;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.lib.jdbc.DelegatingDataSource;
import org.apache.openjpa.lib.jdbc.JDBCEventConnectionDecorator;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.lib.jdbc.LoggingConnectionDecorator;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public class DataSourceFactory {
    private static final Localizer _loc = Localizer.forPackage(DataSourceFactory.class);
    protected static Localizer _eloc = Localizer.forPackage(DelegatingDataSource.class);

    public static DataSource newDataSource(JDBCConfiguration conf, boolean factory2) {
        String driver;
        String string = driver = factory2 ? conf.getConnection2DriverName() : conf.getConnectionDriverName();
        if (StringUtils.isEmpty(driver)) {
            throw new UserException(_loc.get("no-driver", conf)).setFatal(true);
        }
        ClassLoader loader = conf.getClassResolverInstance().getClassLoader(DataSourceFactory.class, null);
        String props = factory2 ? conf.getConnection2Properties() : conf.getConnectionProperties();
        try {
            Class<?> driverClass;
            try {
                driverClass = Class.forName(driver, true, loader);
            }
            catch (ClassNotFoundException cnfe) {
                driverClass = Class.forName(driver);
            }
            if (Driver.class.isAssignableFrom(driverClass)) {
                DriverDataSource ds = conf.newDriverDataSourceInstance();
                ds.setClassLoader(loader);
                ds.setConnectionDriverName(driver);
                ds.setConnectionProperties(Configurations.parseProperties(props));
                if (!factory2) {
                    ds.setConnectionFactoryProperties(Configurations.parseProperties(conf.getConnectionFactoryProperties()));
                    ds.setConnectionURL(conf.getConnectionURL());
                    ds.setConnectionUserName(conf.getConnectionUserName());
                    ds.setConnectionPassword(conf.getConnectionPassword());
                } else {
                    ds.setConnectionFactoryProperties(Configurations.parseProperties(conf.getConnectionFactory2Properties()));
                    ds.setConnectionURL(conf.getConnection2URL());
                    ds.setConnectionUserName(conf.getConnection2UserName());
                    ds.setConnectionPassword(conf.getConnection2Password());
                }
                return ds;
            }
            if (DataSource.class.isAssignableFrom(driverClass)) {
                return (DataSource)Configurations.newInstance(driver, (Configuration)conf, props, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(DataSource.class)));
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw DataSourceFactory.newConnectException(conf, factory2, e);
        }
        throw new UserException(_loc.get("bad-driver", driver)).setFatal(true);
    }

    public static DecoratingDataSource decorateDataSource(DataSource ds, JDBCConfiguration conf, boolean factory2) {
        Options opts = Configurations.parseProperties(factory2 ? conf.getConnectionFactory2Properties() : conf.getConnectionFactoryProperties());
        Log jdbcLog = conf.getLog("openjpa.jdbc.JDBC");
        Log sqlLog = conf.getLog("openjpa.jdbc.SQL");
        DecoratingDataSource dds = new DecoratingDataSource(ds);
        try {
            List<ConnectionDecorator> decs;
            ArrayList<ConnectionDecorator> decorators = new ArrayList<ConnectionDecorator>();
            decorators.addAll(Arrays.asList(conf.getConnectionDecoratorInstances()));
            JDBCEventConnectionDecorator ecd = new JDBCEventConnectionDecorator();
            Configurations.configureInstance((Object)ecd, (Configuration)conf, opts);
            JDBCListener[] listeners = conf.getJDBCListenerInstances();
            for (int i = 0; i < listeners.length; ++i) {
                ecd.addListener(listeners[i]);
            }
            decorators.add(ecd);
            if (ds instanceof DriverDataSource && (decs = ((DriverDataSource)ds).createConnectionDecorators()) != null) {
                decorators.addAll(decs);
            }
            LoggingConnectionDecorator lcd = new LoggingConnectionDecorator();
            Configurations.configureInstance((Object)lcd, (Configuration)conf, opts);
            lcd.getLogs().setJDBCLog(jdbcLog);
            lcd.getLogs().setSQLLog(sqlLog);
            decorators.add(lcd);
            dds.addDecorators(decorators);
            return dds;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw DataSourceFactory.newConnectException(conf, factory2, e);
        }
    }

    public static DecoratingDataSource installDBDictionary(DBDictionary dict, DecoratingDataSource ds, JDBCConfiguration conf, boolean factory2) {
        DataSource inner = ds.getInnermostDelegate();
        if (inner instanceof DriverDataSource) {
            ((DriverDataSource)inner).initDBDictionary(dict);
        }
        Connection conn = null;
        try {
            for (ConnectionDecorator cd : ds.getDecorators()) {
                if (!(cd instanceof LoggingConnectionDecorator)) continue;
                ((LoggingConnectionDecorator)cd).setWarningHandler(dict);
            }
            ConfiguringConnectionDecorator ccd = new ConfiguringConnectionDecorator();
            ccd.setTransactionIsolation(conf.getTransactionIsolationConstant());
            int timeout = conf.getQueryTimeout();
            if (dict.allowQueryTimeoutOnFindUpdate) {
                if (timeout > 0 && timeout < 1000) {
                    timeout = 1;
                } else if (timeout >= 1000) {
                    timeout /= 1000;
                }
            }
            ccd.setQueryTimeout(timeout);
            Log log = conf.getLog("openjpa.jdbc.JDBC");
            if (factory2 || !conf.isConnectionFactoryModeManaged()) {
                if (!dict.supportsMultipleNontransactionalResultSets) {
                    ccd.setAutoCommit(Boolean.FALSE);
                } else {
                    ccd.setAutoCommit(Boolean.TRUE);
                }
                if (log.isTraceEnabled()) {
                    log.trace(_loc.get("set-auto-commit", new Object[]{dict.supportsMultipleNontransactionalResultSets}));
                }
            }
            Options opts = Configurations.parseProperties(factory2 ? conf.getConnectionFactory2Properties() : conf.getConnectionFactoryProperties());
            Configurations.configureInstance((Object)ccd, (Configuration)conf, opts);
            ds.addDecorator(ccd);
            ds.addDecorator(dict);
            conn = !factory2 ? ds.getConnection(conf.getConnectionUserName(), conf.getConnectionPassword()) : ds.getConnection(conf.getConnection2UserName(), conf.getConnection2Password());
            DecoratingDataSource decoratingDataSource = ds;
            return decoratingDataSource;
        }
        catch (Exception e) {
            throw DataSourceFactory.newConnectException(conf, factory2, e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    static OpenJPAException newConnectException(JDBCConfiguration conf, boolean factory2, Exception cause) {
        Object[] objectArray;
        if (factory2) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = conf.getConnection2DriverName();
            objectArray = objectArray2;
            objectArray2[1] = conf.getConnection2URL();
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = conf.getConnectionDriverName();
            objectArray = objectArray3;
            objectArray3[1] = conf.getConnectionURL();
        }
        return new UserException(_eloc.get("poolds-null", objectArray), (Throwable)cause).setFatal(true);
    }

    public static DataSource defaultsDataSource(DataSource ds, String user, String pass) {
        if (user == null && pass == null) {
            return ds;
        }
        if ("".equals(user) && "".equals(pass)) {
            return ds;
        }
        return new DefaultsDataSource(ds, user, pass);
    }

    public static void closeDataSource(DataSource ds) {
        if (ds instanceof DelegatingDataSource) {
            ds = ((DelegatingDataSource)ds).getInnermostDelegate();
        }
        ImplHelper.close(ds);
    }

    private static class DefaultsDataSource
    extends DelegatingDataSource {
        private final String _user;
        private final String _pass;

        public DefaultsDataSource(DataSource ds, String user, String pass) {
            super(ds);
            this._user = user;
            this._pass = pass;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return super.getConnection(this._user, this._pass);
        }

        @Override
        public Connection getConnection(String user, String pass) throws SQLException {
            return super.getConnection(user, pass);
        }
    }
}

